/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import org.openstreetmap.josm.tools.Logging;

public class Combination {
    private long n = 0L;
    private long k = 0L;
    long[] data = null;

    public Combination(long n, long k) {
        if (n < 0L || k < 0L) {
            Logging.error((String)"Negative parameter in constructor");
        }
        this.n = n;
        this.k = k;
        this.data = new long[(int)k];
        for (long i = 0L; i < k; ++i) {
            this.data[(int)i] = i;
        }
    }

    public static long Choose(long n, long k) {
        long iMax;
        long delta;
        if (n < 0L || k < 0L) {
            Logging.error((String)"Invalid negative parameter in Choose()");
        }
        if (n < k) {
            return 0L;
        }
        if (n == k) {
            return 1L;
        }
        if (k < n - k) {
            delta = n - k;
            iMax = k;
        } else {
            delta = k;
            iMax = n - k;
        }
        long ans = delta + 1L;
        for (long i = 2L; i <= iMax; ++i) {
            ans = ans * (delta + i) / i;
        }
        return ans;
    }

    public long Choose() {
        long iMax;
        long delta;
        if (this.n < this.k) {
            return 0L;
        }
        if (this.n == this.k) {
            return 1L;
        }
        if (this.k < this.n - this.k) {
            delta = this.n - this.k;
            iMax = this.k;
        } else {
            delta = this.k;
            iMax = this.n - this.k;
        }
        long ans = delta + 1L;
        for (long i = 2L; i <= iMax; ++i) {
            ans = ans * (delta + i) / i;
        }
        return ans;
    }

    public Combination Successor() {
        long i;
        if (this.data.length == 0 || this.data[0] == this.n - this.k) {
            return null;
        }
        Combination ans = new Combination(this.n, this.k);
        for (i = 0L; i < this.k; ++i) {
            ans.data[(int)i] = this.data[(int)i];
        }
        for (i = this.k - 1L; i > 0L && ans.data[(int)i] == this.n - this.k + i; --i) {
        }
        int n = (int)i;
        ans.data[n] = ans.data[n] + 1L;
        for (long j = i; j < this.k - 1L; ++j) {
            ans.data[(int)j + 1] = ans.data[(int)j] + 1L;
        }
        return ans;
    }

    public String ToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (long i = 0L; i < this.k; ++i) {
            sb.append(this.data[(int)i]);
            if (i >= this.k - 1L) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

