/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.test;

import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.geotools.image.ImageWorker;

public class ImageComparator {
    static final int RED = 0;
    static final int GREEN = 1;
    static final int BLUE = 2;
    static final int ALPHA = 3;
    static final int MIN_BRIGHTNESS = 4;
    static final int MAX_BRIGHTNESS = 5;
    int[] tolerance = new int[6];
    Mode mode;
    long mismatchCount = 0L;
    double mismatchPercent;
    int bands;

    public ImageComparator(Mode mode, RenderedImage image1, RenderedImage image2) {
        int height = image1.getHeight();
        int width = image1.getWidth();
        if (width != image2.getWidth() || height != image2.getHeight()) {
            this.mismatchCount = Integer.MAX_VALUE;
            this.mismatchPercent = 1.0;
            return;
        }
        image1 = this.normalizeImage(image1);
        image2 = this.normalizeImage(image2);
        this.bands = image1.getSampleModel().getNumBands();
        boolean hasAlpha = image1.getColorModel().hasAlpha();
        if (this.bands > 4 || this.bands == 2 && !hasAlpha || this.bands == 3 && hasAlpha) {
            throw new IllegalArgumentException("Images have the wrong type, this code only supports gray, gray/alpha, RGB, RGBA images, or images that can be transformed in those models");
        }
        this.mode = mode;
        switch (mode) {
            case IgnoreNothing: {
                this.tolerance[0] = 16;
                this.tolerance[1] = 16;
                this.tolerance[2] = 16;
                this.tolerance[3] = 16;
                this.tolerance[4] = 16;
                this.tolerance[5] = 240;
                break;
            }
            case IgnoreAntialiasing: {
                this.tolerance[0] = 32;
                this.tolerance[1] = 32;
                this.tolerance[2] = 32;
                this.tolerance[3] = 128;
                this.tolerance[4] = 64;
                this.tolerance[5] = 98;
                break;
            }
            case IgnoreColors: {
                this.tolerance[3] = 16;
                this.tolerance[4] = 16;
                this.tolerance[5] = 240;
            }
        }
        this.computeDifference(image1, image2);
        this.mismatchPercent = (double)this.mismatchCount * 1.0 / (double)(width * image2.getHeight());
    }

    private RenderedImage normalizeImage(RenderedImage image1) {
        if ((image1 = new ImageWorker(image1).forceColorSpaceRGB().forceComponentColorModel().getRenderedImage()).getMinX() != 0 || image1.getMinY() != 0) {
            image1 = PlanarImage.wrapRenderedImage(image1).getAsBufferedImage();
        }
        return image1;
    }

    public double getMismatchPercent() {
        return this.mismatchPercent;
    }

    public long getMismatchCount() {
        return this.mismatchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeDifference(RenderedImage image1, RenderedImage image2) {
        int[] components = new int[this.bands];
        Pixel px1 = new Pixel();
        Pixel px2 = new Pixel();
        int width = image1.getWidth();
        int height = image1.getHeight();
        RandomIter it1 = RandomIterFactory.create(image1, null);
        RandomIter it2 = RandomIterFactory.create(image2, null);
        Pixel cursor = new Pixel();
        try {
            for (int r = 0; r < height; ++r) {
                for (int c = 0; c < width; ++c) {
                    it1.getPixel(c, r, components);
                    px1.init(components);
                    it2.getPixel(c, r, components);
                    px2.init(components);
                    if (this.mode == Mode.IgnoreColors) {
                        if (px1.isBrightnessSimilar(px2)) continue;
                        ++this.mismatchCount;
                        continue;
                    }
                    if (px1.isSimilar(px2)) continue;
                    if (this.mode == Mode.IgnoreAntialiasing) {
                        if (this.isAntialised(px1, it1, r, c, width, height, components, cursor) || this.isAntialised(px2, it2, r, c, width, height, components, cursor)) {
                            if (px1.isBrightnessSimilar(px2)) continue;
                            ++this.mismatchCount;
                            continue;
                        }
                        ++this.mismatchCount;
                        continue;
                    }
                    ++this.mismatchCount;
                }
            }
        }
        finally {
            it1.done();
            it2.done();
        }
    }

    private boolean isAntialised(Pixel source, RandomIter it, int row, int col, int width, int height, int[] pixel, Pixel cursor) {
        boolean DISTANCE = true;
        int highContrastSibling = 0;
        int siblingWithDifferentHue = 0;
        int equivalentSibling = 0;
        int rowMin = Math.max(row - 1, 0);
        int rowMax = Math.min(row + 1, width);
        int colMin = Math.max(col - 1, 0);
        int colMax = Math.min(col + 1, height);
        for (int c = colMin; c < colMax; ++c) {
            for (int r = rowMin; r < rowMax; ++r) {
                if (c == col && r == row) continue;
                it.getPixel(c, r, pixel);
                cursor.init(pixel);
                if (source.isRGBSame(cursor)) {
                    ++equivalentSibling;
                } else if (source.isConstrasting(cursor)) {
                    ++highContrastSibling;
                }
                if (source.hasDifferentHue(cursor)) {
                    ++siblingWithDifferentHue;
                }
                if (siblingWithDifferentHue <= 1 && highContrastSibling <= 1) continue;
                return true;
            }
        }
        return equivalentSibling < 2;
    }

    final class Pixel {
        int r;
        int g;
        int b;
        int a;
        private int brightness;
        private double hue;

        public void init(int[] px) {
            if (ImageComparator.this.bands < 2) {
                this.g = this.b = px[0];
                this.r = this.b;
                this.a = 255;
            } else {
                this.r = px[0];
                this.g = px[1];
                this.b = px[2];
                this.a = ImageComparator.this.bands == 4 ? px[3] : 255;
            }
            this.brightness = Integer.MIN_VALUE;
            this.hue = Double.NaN;
        }

        int getBrightness() {
            if (this.brightness == Integer.MIN_VALUE) {
                this.brightness = (int)Math.round(0.3 * (double)this.r + 0.59 * (double)this.g + 0.11 * (double)this.b);
            }
            return this.brightness;
        }

        double getHue() {
            if (Double.isNaN(this.hue)) {
                double min;
                double r = (double)this.r / 255.0;
                double g = (double)this.g / 255.0;
                double b = (double)this.b / 255.0;
                double max = Math.max(r, Math.max(g, b));
                if (max == (min = Math.min(r, Math.max(g, b)))) {
                    this.hue = 0.0;
                } else {
                    double d = max - min;
                    this.hue = max == r ? (g - b) / d + (double)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0 : (r - g) / d + 4.0);
                    this.hue /= 6.0;
                }
            }
            return this.hue;
        }

        public boolean isRGBSame(Pixel other) {
            if (this.a != other.a) {
                return false;
            }
            if (this.b != other.b) {
                return false;
            }
            if (this.g != other.g) {
                return false;
            }
            return this.r == other.r;
        }

        public boolean isSimilar(Pixel other) {
            return this.isColorSimilar(this.r, other.r, 0) && this.isColorSimilar(this.g, other.g, 1) && this.isColorSimilar(this.b, other.b, 2) && this.isColorSimilar(this.a, other.a, 3);
        }

        public boolean isConstrasting(Pixel other) {
            return Math.abs(this.getBrightness() - other.getBrightness()) > ImageComparator.this.tolerance[5];
        }

        private boolean isColorSimilar(int a, int b, int color) {
            int diff = Math.abs(a - b);
            return diff == 0 || diff < ImageComparator.this.tolerance[color];
        }

        public boolean isBrightnessSimilar(Pixel other) {
            return this.isColorSimilar(this.a, other.a, 3) && this.isColorSimilar(this.getBrightness(), other.getBrightness(), 4);
        }

        public boolean hasDifferentHue(Pixel cursor) {
            return Math.abs(this.getHue() - cursor.getHue()) > 0.3;
        }

        public String toString() {
            return "Pixel [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
        }
    }

    public static enum Mode {
        IgnoreNothing,
        IgnoreAntialiasing,
        IgnoreColors;

    }
}

