/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.zonal;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatsFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.media.jai.ROI;

public class ZoneGeometry {
    private final boolean classification;
    private final Map<Integer, Map<Integer, Map<Range, Statistics[]>>> statsContainer;
    private final Statistics.StatsType[] stats;
    private double[] minBounds;
    private double[] maxBounds;
    private int[] numbins;
    private final ROI roi;
    private List<Range> ranges;

    ZoneGeometry(ROI roi, List<Range> ranges, int[] bands, Statistics.StatsType[] stats, boolean classification, double[] minBounds, double[] maxBounds, int[] numbins) {
        this.classification = classification;
        this.stats = stats;
        this.minBounds = minBounds;
        this.maxBounds = maxBounds;
        this.numbins = numbins;
        this.roi = roi;
        this.ranges = ranges;
        this.statsContainer = new TreeMap<Integer, Map<Integer, Map<Range, Statistics[]>>>();
        for (int i : bands) {
            TreeMap mapClass = new TreeMap();
            if (!classification) {
                HashMap<Range, Statistics[]> mapRange = new HashMap<Range, Statistics[]>();
                for (Range inputRange : ranges) {
                    Statistics[] statistics = new Statistics[stats.length];
                    for (int st = 0; st < stats.length; ++st) {
                        int statId = stats[st].getStatsId();
                        statistics[st] = statId <= 6 ? StatsFactory.createSimpleStatisticsObjectFromInt(statId) : StatsFactory.createComplexStatisticsObjectFromInt(statId, minBounds[i], maxBounds[i], numbins[i]);
                    }
                    mapRange.put(inputRange, statistics);
                }
                mapClass.put(0, mapRange);
            }
            this.statsContainer.put(i, mapClass);
        }
    }

    public synchronized void add(double sample, int band, int classId, Range dataRange) {
        Map<Integer, Map<Range, Statistics[]>> mapClass = this.statsContainer.get(band);
        Map<Range, Statistics[]> mapRange = mapClass.get(classId);
        if (this.classification && mapRange == null) {
            mapRange = new HashMap<Range, Statistics[]>();
            Statistics[] statistics = new Statistics[this.stats.length];
            for (int st = 0; st < this.stats.length; ++st) {
                int statId = this.stats[st].getStatsId();
                statistics[st] = statId <= 6 ? StatsFactory.createSimpleStatisticsObjectFromInt(statId) : StatsFactory.createComplexStatisticsObjectFromInt(statId, this.minBounds[band], this.maxBounds[band], this.numbins[band]);
            }
            mapRange.put(dataRange, statistics);
            mapClass.put(classId, mapRange);
        } else {
            Statistics[] statistics = mapRange.get(dataRange);
            for (int st = 0; st < this.stats.length; ++st) {
                statistics[st].addSample(sample);
            }
        }
    }

    public Statistics[] getStatsPerBandPerClassPerRange(int band, int classId, Range range) {
        Statistics[] statistics = this.statsContainer.get(band).get(classId).get(range);
        return statistics;
    }

    public Statistics[] getStatsPerBandNoClassifier(int band, Range range) {
        Statistics[] statistics = this.statsContainer.get(band).get(0).get(range);
        return statistics;
    }

    public Statistics[] getStatsPerBandNoClassifierNoRange(int band) {
        Range fullRange = this.statsContainer.get(band).get(0).keySet().iterator().next();
        Statistics[] statistics = this.statsContainer.get(band).get(0).get(fullRange);
        return statistics;
    }

    public Statistics[] getStatsPerBandNoRange(int band, int classId) {
        Statistics[] statistics = this.statsContainer.get(band).get(classId).get(this.ranges.get(0));
        return statistics;
    }

    public Map<Integer, Map<Range, Statistics[]>> getStatsPerBand(int band) {
        Map<Integer, Map<Range, Statistics[]>> resultAllClass = this.statsContainer.get(band);
        return resultAllClass;
    }

    public Map<Range, Statistics[]> getStatsPerBandPerClass(int band, int classId) {
        Map<Range, Statistics[]> resultPerClass = this.statsContainer.get(band).get(classId);
        return resultPerClass;
    }

    public int getNumClass() {
        Map<Integer, Map<Range, Statistics[]>> resultAllClass = this.statsContainer.get(0);
        return resultAllClass.size();
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public Set<Integer> getClasses() {
        Map<Integer, Map<Range, Statistics[]>> resultAllClass = this.statsContainer.get(0);
        Set<Integer> classes = resultAllClass.keySet();
        TreeSet<Integer> orderedSet = new TreeSet<Integer>(classes);
        return Collections.unmodifiableSet(orderedSet);
    }

    public Map<Integer, Map<Integer, Map<Range, Statistics[]>>> getTotalStats() {
        return new TreeMap<Integer, Map<Integer, Map<Range, Statistics[]>>>(this.statsContainer);
    }

    public ROI getROI() {
        return this.roi;
    }

    public void clear() {
        this.statsContainer.clear();
    }

    static class StatsPerRange {
        private Statistics[] stats;
        private List<Range> rangeList = new ArrayList<Range>();

        StatsPerRange() {
        }

        public Statistics[] getStats() {
            return this.stats;
        }

        public void setStats(Statistics[] stats) {
            this.stats = stats;
        }

        public List<Range> getRangeList() {
            return this.rangeList;
        }

        public void addRange(Range r) {
            this.rangeList.add(r);
        }

        public void addRanges(List<Range> list) {
            this.rangeList = list;
        }
    }
}

