/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.JaiI18N;
import it.geosolutions.jaiext.warp.WarpPropertyGenerator;
import it.geosolutions.jaiext.warp.WarpRIF;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;

public class WarpDescriptor
extends OperationDescriptorImpl {
    private static final Logger LOGGER = Logger.getLogger(WarpDescriptor.class.toString());
    private static final String[][] resources = new String[][]{{"GlobalName", "Warp"}, {"LocalName", "Warp"}, {"Vendor", "it.geosolutions.jaiext"}, {"Description", "Warps an image according to a specified Warp object."}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ROIAwareWarpDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("WarpDescriptor1")}, {"arg1Desc", JaiI18N.getString("WarpDescriptor2")}, {"arg2Desc", JaiI18N.getString("WarpDescriptor3")}, {"arg3Desc", JaiI18N.getString("WarpDescriptor4")}, {"arg4Desc", JaiI18N.getString("WarpDescriptor5")}};
    private static final String[] paramNames = new String[]{"warp", "interpolation", "backgroundValues", "roi", "nodata"};
    private static final Class[] paramClasses = new Class[]{Warp.class, Interpolation.class, double[].class, ROI.class, Range.class};
    private static final Object[] paramDefaults = new Object[]{NO_PARAMETER_DEFAULT, Interpolation.getInstance(0), null, null, null};

    public static final boolean register() {
        OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
        try {
            WarpDescriptor op = new WarpDescriptor();
            String descName = op.getName();
            if (registry.getDescriptor("rendered", descName) != null) {
                return false;
            }
            registry.registerDescriptor(op);
            WarpRIF rif = new WarpRIF();
            registry.registerFactory("rendered", descName, "it.geosolutions.jaiext", rif);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return false;
        }
    }

    public WarpDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    @Override
    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new WarpPropertyGenerator()};
        return pg;
    }

    public static RenderedOp create(RenderedImage source0, Warp warp, Interpolation interpolation, double[] backgroundValues, ROI sourceROI, RenderingHints hints) {
        return WarpDescriptor.create(source0, warp, interpolation, backgroundValues, sourceROI, null, hints);
    }

    public static RenderedOp create(RenderedImage source0, Warp warp, Interpolation interpolation, double[] backgroundValues, ROI sourceROI, Range noData, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Warp", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("warp", warp);
        pb.setParameter("interpolation", interpolation);
        if (backgroundValues != null) {
            pb.setParameter("backgroundValues", backgroundValues);
        }
        if (sourceROI != null) {
            pb.setParameter("roi", sourceROI);
        }
        if (noData != null) {
            pb.setParameter("nodata", noData);
        }
        return JAI.create("Warp", pb, hints);
    }
}

