/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapdust.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapdust.MapdustPlugin;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustActionPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugListPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.component.panel.MapdustBugPropertiesPanel;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustActionObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustBugDetailsObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObservable;
import org.openstreetmap.josm.plugins.mapdust.gui.observer.MapdustUpdateObserver;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustAction;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustPluginState;
import org.openstreetmap.josm.plugins.mapdust.gui.value.MapdustServiceCommand;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBug;
import org.openstreetmap.josm.plugins.mapdust.service.value.MapdustBugFilter;
import org.openstreetmap.josm.plugins.mapdust.service.value.Status;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapdustGUI
extends ToggleDialog
implements MapdustActionObserver,
MapdustBugDetailsObservable,
MapdustUpdateObservable {
    private static final long serialVersionUID = -1194197412364335190L;
    private final ArrayList<MapdustBugDetailsObserver> bugDetailsObservers = new ArrayList();
    private final ArrayList<MapdustUpdateObserver> initialUpdateObservers = new ArrayList();
    private MapdustPlugin mapdustPlugin;
    private MapdustBugPropertiesPanel detailsPanel;
    private MapdustBugListPanel panel;
    private MapdustActionPanel actionPanel;
    private JTabbedPane tabbedPane;
    private JPanel mainPanel;
    private boolean downloaded;
    private boolean destroyed;

    public MapdustGUI(String name, String iconName, String tooltip, Shortcut shortcut, int preferredHeight, MapdustPlugin mapdustPlugin) {
        super(I18n.tr((String)name, (Object[])new Object[0]), iconName, I18n.tr((String)tooltip, (Object[])new Object[0]), shortcut, preferredHeight);
        this.mapdustPlugin = mapdustPlugin;
    }

    public void showDialog() {
        if (!this.downloaded) {
            this.notifyObservers(null, true);
            this.downloaded = true;
        }
        super.showDialog();
    }

    public void destroy() {
        this.setVisible(false);
        if (this.tabbedPane != null) {
            this.remove(this.mainPanel);
            this.tabbedPane = null;
            this.actionPanel = null;
            this.mainPanel = null;
            this.panel = null;
            this.actionPanel = null;
        } else if (this.mainPanel != null) {
            this.remove(this.mainPanel);
            this.mainPanel = null;
            this.panel = null;
            this.detailsPanel = null;
        }
        this.downloaded = false;
        this.button.setSelected(false);
        if (!this.destroyed) {
            super.destroy();
            this.destroyed = true;
        }
    }

    protected void toggleButtonHook() {
        if (this.isVisible()) {
            this.setVisible(false);
            this.button.setSelected(false);
        } else {
            this.setVisible(true);
        }
    }

    @Override
    public synchronized void addAction(MapdustAction action) {
        List<MapdustAction> actionList = this.actionPanel.getActionList();
        actionList.add(action);
        List<MapdustBug> mapdustBugs = this.panel.getMapdustBugsList();
        boolean showBug = this.shouldDisplay(action.getMapdustBug(), this.mapdustPlugin.getFilter());
        mapdustBugs = this.modifyBug(mapdustBugs, action.getMapdustBug(), showBug);
        this.updateMapdustPanel(mapdustBugs);
        this.updateMapdustActionPanel(actionList);
        if (showBug && !action.getCommand().equals((Object)MapdustServiceCommand.ADD_BUG)) {
            this.panel.resetSelectedBug(0);
        } else {
            this.mapdustPlugin.getMapdustLayer().setBugSelected(null);
        }
        this.revalidate();
        MainApplication.getMap().mapView.revalidate();
        MainApplication.getMap().repaint();
    }

    private boolean shouldDisplay(MapdustBug modifiedBug, MapdustBugFilter filter) {
        boolean result = false;
        if (filter != null && filter.getStatuses() != null && !filter.getStatuses().isEmpty()) {
            if (filter.getStatuses().contains(modifiedBug.getStatus().getKey())) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public synchronized void update(List<MapdustBug> mapdustBugs, MapdustPlugin mapdustPlugin) {
        this.setMapdustPlugin(mapdustPlugin);
        String pluginState = Config.getPref().get("mapdust.pluginState");
        if (pluginState.equals(MapdustPluginState.ONLINE.getValue())) {
            if (this.tabbedPane != null) {
                this.remove(this.mainPanel);
                this.tabbedPane = null;
                this.actionPanel = null;
                this.mainPanel = null;
                this.panel = null;
            }
            this.updateMapdustPanel(mapdustBugs);
            if (this.mainPanel == null) {
                this.createMainPanel();
            }
        } else {
            if (this.tabbedPane == null) {
                this.remove(this.mainPanel);
                this.mainPanel = null;
                this.panel = null;
            }
            ArrayList<MapdustAction> actionList = this.actionPanel != null ? this.actionPanel.getActionList() : new ArrayList();
            List<MapdustBug> bugs = this.filterMapdustBugList(mapdustBugs, actionList, mapdustPlugin.getFilter());
            this.updateMapdustPanel(bugs);
            this.updateMapdustActionPanel(actionList);
            if (this.mainPanel == null) {
                this.createMainPanel();
            }
        }
    }

    private void updateMapdustPanel(List<MapdustBug> mapdustBugs) {
        MapdustBug selectedBug;
        MapdustBug mapdustBug = selectedBug = mapdustBugs != null && mapdustBugs.size() > 0 ? mapdustBugs.get(0) : null;
        if (this.detailsPanel == null) {
            this.detailsPanel = new MapdustBugPropertiesPanel(selectedBug);
            this.addObserver(this.detailsPanel);
        }
        if (this.panel == null) {
            this.panel = new MapdustBugListPanel(mapdustBugs, "Bug reports", this.mapdustPlugin);
            this.panel.addObserver(this.detailsPanel);
        } else {
            this.panel.updateComponents(mapdustBugs);
            this.notifyObservers(selectedBug);
        }
    }

    private void updateMapdustActionPanel(List<MapdustAction> actionList) {
        if (this.actionPanel == null) {
            this.actionPanel = new MapdustActionPanel(actionList, "Offline Contribution", this.mapdustPlugin);
        } else {
            this.actionPanel.updateComponents(actionList);
        }
    }

    private void createMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setAutoscrolls(true);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.detailsPanel, "North");
        if (this.actionPanel == null) {
            this.mainPanel.add((Component)this.panel, "Center");
        } else {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.add((Component)this.panel, 0);
            this.tabbedPane.add(this.actionPanel);
            this.mainPanel.add((Component)this.tabbedPane, "Center");
        }
        this.createLayout(this.mainPanel, false, null);
    }

    private List<MapdustBug> filterMapdustBugList(List<MapdustBug> bugList, List<MapdustAction> actionList, MapdustBugFilter filter) {
        if (bugList != null && actionList != null) {
            for (MapdustAction action : actionList) {
                int index = bugList.indexOf(action.getMapdustBug());
                if (index < 0 || action.getNewStatus() == null) continue;
                Status newStatus = Status.getStatus(action.getNewStatus());
                if (filter != null && filter.getStatuses() != null && !filter.getStatuses().isEmpty()) {
                    if (filter.getStatuses().contains(newStatus.getKey())) {
                        bugList.get(index).setStatus(newStatus);
                        continue;
                    }
                    bugList.remove(index);
                    continue;
                }
                bugList.get(index).setStatus(newStatus);
            }
        }
        return bugList;
    }

    private List<MapdustBug> modifyBug(List<MapdustBug> mapdustBugs, MapdustBug modifiedBug, boolean showBug) {
        int index = -1;
        for (int i = 0; i < mapdustBugs.size(); ++i) {
            if (modifiedBug.getId() == null || !mapdustBugs.get(i).getId().equals(modifiedBug.getId())) continue;
            index = i;
        }
        if (index != -1) {
            mapdustBugs.remove(index);
            if (showBug) {
                mapdustBugs.add(0, modifiedBug);
            }
        }
        return mapdustBugs;
    }

    public MapdustBug getSelectedBug() {
        MapdustBug selectedBug = null;
        if (this.panel != null) {
            selectedBug = this.panel.getSelectedBug();
        }
        return selectedBug;
    }

    public void setSelectedBug(MapdustBug mapdustBug) {
        if (this.panel != null) {
            this.panel.setSelectedBug(mapdustBug);
        }
    }

    public void disableBtnPanel() {
        if (this.panel != null) {
            this.panel.disableBtnPanel();
        }
    }

    public void enableBtnPanel(boolean onlyBasic) {
        if (this.panel != null) {
            this.panel.enableBtnPanel(onlyBasic);
        }
    }

    public List<MapdustAction> getMapdustActionList() {
        return this.getActionPanel().getActionList();
    }

    @Override
    public void addObserver(MapdustBugDetailsObserver observer) {
        if (!this.bugDetailsObservers.contains(observer)) {
            this.bugDetailsObservers.add(observer);
        }
    }

    @Override
    public void addObserver(MapdustUpdateObserver observer) {
        if (!this.initialUpdateObservers.contains(observer)) {
            this.initialUpdateObservers.add(observer);
        }
    }

    @Override
    public void removeObserver(MapdustBugDetailsObserver observer) {
        this.bugDetailsObservers.remove(observer);
    }

    @Override
    public void removeObserver(MapdustUpdateObserver observer) {
        this.initialUpdateObservers.remove(observer);
    }

    @Override
    public void notifyObservers(MapdustBug mapdustBug) {
        Iterator<MapdustBugDetailsObserver> elements = this.bugDetailsObservers.iterator();
        while (elements.hasNext()) {
            elements.next().showDetails(mapdustBug);
        }
    }

    @Override
    public void notifyObservers(MapdustBugFilter filter, boolean first) {
        Iterator<MapdustUpdateObserver> elements = this.initialUpdateObservers.iterator();
        while (elements.hasNext()) {
            elements.next().update(filter, first);
        }
    }

    public MapdustBugListPanel getPanel() {
        return this.panel;
    }

    public MapdustActionPanel getActionPanel() {
        return this.actionPanel;
    }

    public MapdustPlugin getMapdustPlugin() {
        return this.mapdustPlugin;
    }

    public void setMapdustPlugin(MapdustPlugin mapdustPlugin) {
        this.mapdustPlugin = mapdustPlugin;
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }
}

