/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class CopyTagsAction
extends JosmAction {
    public CopyTagsAction() {
        super(I18n.tr((String)"Copy Tags", (Object[])new Object[0]), "copy", I18n.tr((String)"Copy all tags of selected objects to paste buffer.", (Object[])new Object[0]), CopyTagsAction.createShortcut(), true, CopyTagsAction.class.getName(), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/CopyTags"));
    }

    public static Shortcut createShortcut() {
        return Shortcut.registerShortcut((String)"system:copytags", (String)I18n.tr((String)"Edit: {0}", (Object[])new Object[]{I18n.tr((String)"Copy Tags", (Object[])new Object[0])}), (int)65535, (int)5000);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.isEmptySelection()) {
            return;
        }
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        CopyTagsAction.copy(this.getLayerManager().getEditLayer(), selection);
    }

    public static void copy(OsmDataLayer source, Collection<OsmPrimitive> primitives) {
        TreeSet<String> values = new TreeSet<String>();
        for (OsmPrimitive p : primitives) {
            for (Map.Entry kv : p.getKeys().entrySet()) {
                values.add(new Tag((String)kv.getKey(), (String)kv.getValue()).toString());
            }
        }
        if (!values.isEmpty()) {
            ClipboardUtils.copyString((String)Utils.join((String)"\n", values));
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }

    private boolean isEmptySelection() {
        Collection sel = this.getLayerManager().getEditDataSet().getSelected();
        if (sel.isEmpty()) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please select something to copy.", (Object[])new Object[0]), I18n.tr((String)"Information", (Object[])new Object[0]), 1);
            return true;
        }
        return false;
    }
}

