/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.filter.GeometryFilterImpl;
import org.opengis.filter.MultiValuedFilter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.DistanceBufferOperator;

public abstract class CartesianDistanceFilter
extends GeometryFilterImpl
implements DistanceBufferOperator {
    private double distance;
    private String units;

    protected CartesianDistanceFilter(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected CartesianDistanceFilter(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public String getDistanceUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public String toString() {
        String operator = null;
        if (this instanceof Beyond) {
            operator = " beyond ";
        } else if (this instanceof DWithin) {
            operator = " dwithin ";
        }
        String distStr = ", distance: " + this.distance;
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        if (leftGeometry == null && rightGeometry == null) {
            return "[ null" + operator + "null" + distStr + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator + rightGeometry.toString() + distStr + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator + "null" + distStr + " ]";
        }
        return "[ " + leftGeometry.toString() + operator + rightGeometry.toString() + distStr + " ]";
    }

    @Override
    public boolean equals(Object oFilter) {
        return super.equals(oFilter) && this.distance == ((CartesianDistanceFilter)oFilter).distance;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long bits = Double.doubleToLongBits(this.distance);
        result = 37 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

