/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.filter.capability.FunctionName;

public class FilterFunction_vertices
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("vertices", FunctionNameImpl.parameter("vertices", MultiPoint.class), FunctionNameImpl.parameter("geometry", Geometry.class));

    public FilterFunction_vertices() {
        super(NAME);
    }

    public Object evaluate(Object feature, Class context) {
        Geometry g = this.getExpression(0).evaluate(feature, Geometry.class);
        if (g == null) {
            return null;
        }
        MultiPointExtractor filter = new MultiPointExtractor();
        g.apply((CoordinateFilter)filter);
        return filter.getMultiPoint();
    }

    static class MultiPointExtractor
    implements CoordinateFilter {
        List<Coordinate> coordinates = new ArrayList<Coordinate>();

        MultiPointExtractor() {
        }

        public void filter(Coordinate c) {
            this.coordinates.add(c);
        }

        MultiPoint getMultiPoint() {
            Coordinate[] coorArray = this.coordinates.toArray(new Coordinate[this.coordinates.size()]);
            return new GeometryFactory().createMultiPoint((CoordinateSequence)new CoordinateArraySequence(coorArray));
        }
    }
}

