/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.elevation.ElevationHelper;
import org.openstreetmap.josm.plugins.elevation.IElevationProfile;
import org.openstreetmap.josm.plugins.elevation.gpx.ElevationWayPointKind;
import org.openstreetmap.josm.plugins.elevation.gui.ElevationColors;
import org.openstreetmap.josm.plugins.elevation.gui.IElevationProfileRenderer;
import org.openstreetmap.josm.plugins.elevation.gui.Triangle;
import org.openstreetmap.josm.plugins.elevation.gui.TriangleDir;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;

public class DefaultElevationProfileRenderer
implements IElevationProfileRenderer {
    private static final int ROUND_RECT_RADIUS = 6;
    private static final int TRIANGLE_BASESIZE = 24;
    private static final int BASIC_WPT_RADIUS = 1;
    private static final int BIG_WPT_RADIUS = 16;
    private static final Color HIGH_COLOR = ElevationColors.EPMidBlue;
    private static final Color LOW_COLOR = ElevationColors.EPMidBlue;
    private static final Color START_COLOR = Color.GREEN;
    private static final Color END_POINT = Color.RED;
    private static final Color LEVEL_GAIN_COLOR = Color.GREEN;
    private static final Color LEVEL_LOSS_COLOR = Color.RED;
    private static final Color MARKER_POINT = Color.YELLOW;
    private static final double RAD_180 = Math.PI;
    private static final double RAD_90 = 1.5707963267948966;
    private final List<Rectangle> forbiddenRects = new ArrayList<Rectangle>();

    @Override
    public Color getColorForWaypoint(IElevationProfile profile, WayPoint wpt, ElevationWayPointKind kind) {
        if (wpt == null || profile == null) {
            Logging.error((String)String.format("Cannot determine color: prof=%s, wpt=%s", profile, wpt));
            return null;
        }
        switch (kind) {
            case Plain: {
                return Color.LIGHT_GRAY;
            }
            case ElevationLevelLoss: {
                return LEVEL_LOSS_COLOR;
            }
            case ElevationLevelGain: {
                return LEVEL_GAIN_COLOR;
            }
            case Highlighted: {
                return Color.ORANGE;
            }
            case ElevationGainHigh: {
                return Color.getHSBColor(0.3f, 1.0f, 1.0f);
            }
            case ElevationLossHigh: {
                return Color.getHSBColor(0.0f, 1.0f, 1.0f);
            }
            case ElevationGainLow: {
                return Color.getHSBColor(0.3f, 0.5f, 1.0f);
            }
            case ElevationLossLow: {
                return Color.getHSBColor(0.0f, 0.5f, 1.0f);
            }
            case FullHour: {
                return MARKER_POINT;
            }
            case MaxElevation: {
                return HIGH_COLOR;
            }
            case MinElevation: {
                return LOW_COLOR;
            }
            case StartPoint: {
                return START_COLOR;
            }
            case EndPoint: {
                return END_POINT;
            }
        }
        throw new RuntimeException("Unknown way point kind: " + (Object)((Object)kind));
    }

    @Override
    public void renderWayPoint(Graphics g, IElevationProfile profile, MapView mv, WayPoint wpt, ElevationWayPointKind kind) {
        CheckParameterUtil.ensureParameterNotNull((Object)g, (String)"graphics");
        CheckParameterUtil.ensureParameterNotNull((Object)profile, (String)"profile");
        CheckParameterUtil.ensureParameterNotNull((Object)mv, (String)"map view");
        if (wpt == null) {
            Logging.error((String)String.format("Cannot paint: mv=%s, prof=%s, wpt=%s", mv, profile, wpt));
            return;
        }
        switch (kind) {
            case MaxElevation: 
            case MinElevation: {
                this.renderMinMaxPoint(g, profile, mv, wpt, kind);
                break;
            }
            case StartPoint: 
            case EndPoint: {
                this.renderStartEndPoint(g, profile, mv, wpt, kind);
                break;
            }
            default: {
                this.renderRegularWayPoint(g, profile, mv, wpt, kind);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLine(Graphics g, IElevationProfile profile, MapView mv, WayPoint wpt1, WayPoint wpt2, ElevationWayPointKind kind) {
        CheckParameterUtil.ensureParameterNotNull((Object)g, (String)"graphics");
        CheckParameterUtil.ensureParameterNotNull((Object)profile, (String)"profile");
        CheckParameterUtil.ensureParameterNotNull((Object)mv, (String)"map view");
        if (wpt1 == null || wpt2 == null) {
            Logging.error((String)String.format("Cannot paint line: mv=%s, prof=%s, kind = %s", new Object[]{mv, profile, kind}));
            return;
        }
        g.setColor(this.getColorForWaypoint(profile, wpt2, kind));
        Point pnt1 = mv.getPoint(wpt1.getEastNorth((Projecting)ProjectionRegistry.getProjection()));
        Point pnt2 = mv.getPoint(wpt2.getEastNorth((Projecting)ProjectionRegistry.getProjection()));
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldS = g2.getStroke();
            try {
                g2.setStroke(new BasicStroke(3.0f, 1, 1));
                g2.drawLine(pnt1.x, pnt1.y, pnt2.x, pnt2.y);
            }
            finally {
                g2.setStroke(oldS);
            }
        } else {
            g.drawLine(pnt1.x, pnt1.y, pnt2.x, pnt2.y);
        }
    }

    private void renderRegularWayPoint(Graphics g, IElevationProfile profile, MapView mv, WayPoint wpt, ElevationWayPointKind kind) {
        Color c = this.getColorForWaypoint(profile, wpt, kind);
        Point pnt = mv.getPoint(wpt.getEastNorth((Projecting)ProjectionRegistry.getProjection()));
        if (kind == ElevationWayPointKind.FullHour) {
            int hour = ElevationHelper.getHourOfWayPoint(wpt);
            this.drawLabel(String.format("%02d:00", hour), pnt.x, pnt.y + g.getFontMetrics().getHeight(), g);
        }
        if (kind == ElevationWayPointKind.ElevationLevelGain || kind == ElevationWayPointKind.ElevationLevelLoss) {
            int ele = (int)Math.rint(ElevationHelper.getElevation(wpt) / 100.0) * 100;
            this.drawLabelWithTriangle(ElevationHelper.getElevationText(ele), pnt.x, pnt.y + g.getFontMetrics().getHeight(), g, Color.darkGray, 8, this.getColorForWaypoint(profile, wpt, kind), kind == ElevationWayPointKind.ElevationLevelGain ? TriangleDir.Up : TriangleDir.Down);
        }
        if (kind == ElevationWayPointKind.Highlighted) {
            this.drawSphere(g, Color.WHITE, c, pnt.x, pnt.y, 16);
            this.drawLabel(ElevationHelper.getTimeText(wpt), pnt.x, pnt.y - g.getFontMetrics().getHeight() - 5, g);
            this.drawLabel(ElevationHelper.getElevationText(wpt), pnt.x, pnt.y + g.getFontMetrics().getHeight() + 5, g);
        }
    }

    private void renderMinMaxPoint(Graphics g, IElevationProfile profile, MapView mv, WayPoint wpt, ElevationWayPointKind kind) {
        Color c = this.getColorForWaypoint(profile, wpt, kind);
        int eleH = (int)ElevationHelper.getElevation(wpt);
        Point pnt = mv.getPoint(wpt.getEastNorth((Projecting)ProjectionRegistry.getProjection()));
        TriangleDir td = TriangleDir.Up;
        switch (kind) {
            case MaxElevation: {
                td = TriangleDir.Up;
                break;
            }
            case MinElevation: {
                td = TriangleDir.Down;
                break;
            }
            case EndPoint: {
                td = TriangleDir.Left;
                break;
            }
            case StartPoint: {
                td = TriangleDir.Right;
                break;
            }
            default: {
                return;
            }
        }
        this.drawRegularTriangle(g, c, td, pnt.x, pnt.y, 24);
        this.drawLabel(ElevationHelper.getElevationText(eleH), pnt.x, pnt.y + g.getFontMetrics().getHeight(), g, c);
    }

    private void drawRegularTriangle(Graphics g, Color c, TriangleDir dir, int x, int y, int baseLength) {
        if (baseLength < 2) {
            return;
        }
        int b2 = baseLength >> 1;
        Point[] p = new Point[3];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new Point();
        }
        p[0].x = -b2;
        p[0].y = b2;
        p[1].x = b2;
        p[1].y = b2;
        p[2].x = 0;
        p[2].y = -b2;
        Triangle t = new Triangle(p[0], p[1], p[2]);
        double theta = 0.0;
        switch (dir) {
            case Up: {
                theta = 0.0;
                break;
            }
            case Down: {
                theta = Math.PI;
                break;
            }
            case Left: {
                theta = -1.5707963267948966;
                break;
            }
            case Right: {
                theta = 1.5707963267948966;
            }
        }
        AffineTransform at = AffineTransform.getRotateInstance(theta);
        Shape tRot = at.createTransformedShape(t);
        AffineTransform at2 = AffineTransform.getTranslateInstance(x, y);
        Shape ts = at2.createTransformedShape(tRot);
        Graphics2D g2 = (Graphics2D)g;
        if (g2 != null) {
            Color oldC = g2.getColor();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(c);
            g2.fill(ts);
            g2.setColor(oldC);
        }
    }

    private void renderStartEndPoint(Graphics g, IElevationProfile profile, MapView mv, WayPoint wpt, ElevationWayPointKind kind) {
        Color c = this.getColorForWaypoint(profile, wpt, kind);
        Point pnt = mv.getPoint(wpt.getEastNorth((Projecting)ProjectionRegistry.getProjection()));
        this.drawSphere(g, Color.WHITE, c, pnt.x, pnt.y, 16);
    }

    private void drawSphere(Graphics g, Color firstCol, Color secondCol, int x, int y, int radius) {
        Point2D.Float center = new Point2D.Float(x, y);
        Point2D.Float focus = new Point2D.Float((float)x - (float)radius * 0.6f, (float)y - (float)radius * 0.6f);
        float[] dist = new float[]{0.1f, 0.2f, 1.0f};
        Color[] colors = new Color[]{firstCol, secondCol, Color.DARK_GRAY};
        RadialGradientPaint p = new RadialGradientPaint(center, (float)radius, focus, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        Graphics2D g2 = (Graphics2D)g;
        if (g2 != null) {
            g2.setPaint(p);
            int r2 = radius / 2;
            g2.fillOval(x - r2, y - r2, radius, radius);
        }
    }

    private void drawLabel(String s, int x, int y, Graphics g) {
        this.drawLabel(s, x, y, g, Color.GRAY);
    }

    private void drawLabel(String s, int x, int y, Graphics g, Color secondGradColor) {
        int height;
        Graphics2D g2d = (Graphics2D)g;
        int width = g.getFontMetrics(g.getFont()).stringWidth(s) + 10;
        Rectangle r = new Rectangle(x - width / 2, y - (height = g.getFont().getSize() + g.getFontMetrics().getLeading() + 5) / 2, width, height);
        if (this.isForbiddenArea(r)) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(x, y, Color.WHITE, x, y + height / 2, secondGradColor, false);
        g2d.setPaint(gradient);
        g2d.fillRoundRect(r.x, r.y, r.width, r.height, 6, 6);
        g2d.setColor(Color.BLACK);
        g2d.drawRoundRect(r.x, r.y, r.width, r.height, 6, 6);
        g2d.drawString(s, x - width / 2 + 5, y + height / 2 - 3);
        this.forbiddenRects.add(r);
    }

    private void drawLabelWithTriangle(String s, int x, int y, Graphics g, Color secondGradColor, int baseLength, Color triangleColor, TriangleDir triangleDir) {
        int height;
        Graphics2D g2d = (Graphics2D)g;
        int width = g.getFontMetrics(g.getFont()).stringWidth(s) + 10 + baseLength + 5;
        Rectangle r = new Rectangle(x - width / 2, y - (height = g.getFont().getSize() + g.getFontMetrics().getLeading() + 5) / 2, width, height);
        if (this.isForbiddenArea(r)) {
            return;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gradient = new GradientPaint(x, y, Color.WHITE, x, y + height / 2, secondGradColor, false);
        g2d.setPaint(gradient);
        g2d.fillRoundRect(r.x, r.y, r.width, r.height, 6, 6);
        g2d.setColor(Color.BLACK);
        g2d.drawRoundRect(r.x, r.y, r.width, r.height, 6, 6);
        g2d.drawString(s, x - width / 2 + 8 + baseLength, y + height / 2 - 3);
        this.drawRegularTriangle(g2d, triangleColor, triangleDir, r.x + baseLength, r.y + baseLength, baseLength);
        this.forbiddenRects.add(r);
    }

    private boolean isForbiddenArea(Rectangle r) {
        for (Rectangle rTest : this.forbiddenRects) {
            if (!r.intersects(rTest)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beginRendering() {
        this.forbiddenRects.clear();
    }

    @Override
    public void finishRendering() {
    }
}

