/*
 * Decompiled with CFR 0.152.
 */
package touchscreenhelper;

import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import touchscreenhelper.TimedKeyReleaseListener;

public class BrowseAction
extends MapMode
implements MouseListener,
MouseMotionListener,
MapFrame.MapModeChangeListener {
    private MapMode oldMapMode;
    private TimedKeyReleaseListener listener;
    private EastNorth mousePosMove;
    private boolean movementInPlace = false;

    public BrowseAction() {
        super(I18n.tr((String)"Browse", (Object[])new Object[0]), "browse", I18n.tr((String)"Browse map with left button", (Object[])new Object[0]), Shortcut.registerShortcut((String)"touchscreenhelper:browse", (String)I18n.tr((String)"Mode: {0}", (Object[])new Object[]{I18n.tr((String)"Browse map with left button", (Object[])new Object[0])}), (int)84, (int)5003), Cursor.getPredefinedCursor(13));
        MapFrame.addMapModeChangeListener((MapFrame.MapModeChangeListener)this);
    }

    public void mapModeChange(MapMode oldMapMode, MapMode newMapMode) {
        this.oldMapMode = oldMapMode;
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)this);
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)this);
        this.listener = new TimedKeyReleaseListener(){

            @Override
            protected void doKeyReleaseEvent(KeyEvent evt) {
                if (evt.getKeyCode() == BrowseAction.this.getShortcut().getKeyStroke().getKeyCode() && BrowseAction.this.oldMapMode != null && !(BrowseAction.this.oldMapMode instanceof BrowseAction)) {
                    MainApplication.getMap().selectMapMode(BrowseAction.this.oldMapMode);
                }
            }
        };
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)this);
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)this);
        this.listener.stop();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) != 1024) {
            this.endMovement();
            return;
        }
        if (this.mousePosMove == null) {
            this.startMovement(e);
        }
        EastNorth center = MainApplication.getMap().mapView.getCenter();
        EastNorth mouseCenter = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
        MainApplication.getMap().mapView.zoomTo(new EastNorth(this.mousePosMove.east() + center.east() - mouseCenter.east(), this.mousePosMove.north() + center.north() - mouseCenter.north()));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.startMovement(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent e) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = MainApplication.getMap().mapView.getEastNorth(e.getX(), e.getY());
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        this.mousePosMove = null;
    }
}

