/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.surveyor;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.surveyor.SurveyorLock;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class AutoSaveEditLayerTimerTask
extends TimerTask {
    private File file;

    public AutoSaveEditLayerTimerTask(String filename) {
        this.file = new File(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OsmDataLayer layer = MainApplication.getLayerManager().getEditLayer();
        if (layer == null) {
            return;
        }
        try {
            DataSet dataset = layer.data;
            File tmpFile = new File(this.file.getAbsoluteFile() + ".tmp");
            Logging.info((String)("AutoSaving osm data to file " + this.file.getAbsolutePath()));
            Class<SurveyorLock> clazz = SurveyorLock.class;
            synchronized (SurveyorLock.class) {
                OsmWriter w = OsmWriterFactory.createOsmWriter((PrintWriter)new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), StandardCharsets.UTF_8)), (boolean)false, (String)dataset.getVersion());
                w.header();
                w.writeDataSources(dataset);
                w.writeContent(dataset);
                w.footer();
                // ** MonitorExit[var4_5] (shouldn't be in output)
                tmpFile.renameTo(this.file);
            }
        }
        catch (IOException ex) {
            Logging.error((Throwable)ex);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error while exporting {0}: {1}", (Object[])new Object[]{this.file.getAbsoluteFile(), ex.getMessage()}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
        }
    }
}

