/*
 * Decompiled with CFR 0.152.
 */
package views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import model.TagCatalog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.I18n;
import views.PresetButton;

public class ToolBoxView
extends ToggleDialog {
    private JPanel dialogPanel;
    private JPanel contentPanel;
    private JLabel levelLabel;
    private JCheckBox levelCheckBox;
    private JLabel levelNameLabel;
    private DisableShortcutsOnFocusGainedTextField levelNameField;
    private JLabel repeatOnLabel;
    private DisableShortcutsOnFocusGainedTextField repeatOnField;
    private JLabel objectLabel;
    private JosmComboBox<TagCatalog.IndoorObject> objectBox;
    private JLabel nameLabel;
    private DisableShortcutsOnFocusGainedTextField nameField;
    private JLabel refLabel;
    private DisableShortcutsOnFocusGainedTextField refField;
    private JLabel multiLabel;
    private JButton multiOuterButton;
    private JButton multiInnerButton;
    private JCheckBox multiCheckBox;
    private JPanel buttonBar;
    private JButton applyButton;
    private JSeparator separator1;
    private JSeparator separator2;
    private PresetButton preset1;
    private PresetButton preset2;
    private PresetButton preset3;
    private PresetButton preset4;
    private JButton addLevelButton;
    private JButton helpButton;

    public ToolBoxView() {
        super(I18n.tr((String)"Indoor Mapping Helper", (Object[])new Object[0]), "indoorhelper", I18n.tr((String)"Toolbox for indoor mapping assistance", (Object[])new Object[0]), null, 300, true);
        this.initComponents();
    }

    private void initComponents() {
        this.dialogPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.levelLabel = new JLabel();
        this.levelCheckBox = new JCheckBox();
        this.levelNameLabel = new JLabel();
        this.levelNameField = new DisableShortcutsOnFocusGainedTextField();
        this.repeatOnLabel = new JLabel();
        this.repeatOnField = new DisableShortcutsOnFocusGainedTextField();
        this.objectLabel = new JLabel();
        this.objectBox = new JosmComboBox((Object[])TagCatalog.IndoorObject.values());
        this.nameLabel = new JLabel();
        this.nameField = new DisableShortcutsOnFocusGainedTextField();
        this.refLabel = new JLabel();
        this.refField = new DisableShortcutsOnFocusGainedTextField();
        this.multiLabel = new JLabel();
        this.multiOuterButton = new JButton();
        this.multiInnerButton = new JButton();
        this.multiCheckBox = new JCheckBox();
        this.buttonBar = new JPanel();
        this.applyButton = new JButton();
        this.separator1 = new JSeparator();
        this.separator2 = new JSeparator();
        this.preset1 = new PresetButton(TagCatalog.IndoorObject.ROOM);
        this.preset2 = new PresetButton(TagCatalog.IndoorObject.STEPS);
        this.preset3 = new PresetButton(TagCatalog.IndoorObject.CONCRETE_WALL);
        this.preset4 = new PresetButton(TagCatalog.IndoorObject.GLASS_WALL);
        this.addLevelButton = new JButton();
        this.helpButton = new JButton();
        this.dialogPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPanel.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.addLevelButton.setText(I18n.tr((String)"Insert level", (Object[])new Object[0]));
        this.addLevelButton.setToolTipText(I18n.tr((String)"Add a new level to layer.", (Object[])new Object[0]));
        this.addLevelButton.setEnabled(false);
        this.contentPanel.add((Component)this.addLevelButton, new GridBagConstraints(12, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.helpButton.setText(I18n.tr((String)"help", (Object[])new Object[0]));
        this.helpButton.setToolTipText(I18n.tr((String)"Show Help-Browser.", (Object[])new Object[0]));
        this.helpButton.setBackground(Color.LIGHT_GRAY);
        this.helpButton.setEnabled(false);
        this.contentPanel.add((Component)this.helpButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.levelNameLabel.setText(I18n.tr((String)"Level name", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelNameLabel, new GridBagConstraints(0, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelNameField.setEnabled(false);
        this.levelNameField.setToolTipText(I18n.tr((String)"Sets optional name tag for a level.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelNameField, new GridBagConstraints(3, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.levelLabel.setText(I18n.tr((String)"Working level: NONE", (Object[])new Object[0]));
        this.levelLabel.setToolTipText(I18n.tr((String)"Shows the current working level.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelLabel, new GridBagConstraints(6, 1, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.levelCheckBox.setToolTipText(I18n.tr((String)"Deactivate automatic level tagging.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.levelCheckBox, new GridBagConstraints(9, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.contentPanel.add((Component)this.separator1, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.objectLabel.setText(I18n.tr((String)"Object", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.objectLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.objectBox.setEnabled(false);
        this.objectBox.setPrototypeDisplayValue((Object)TagCatalog.IndoorObject.CONCRETE_WALL);
        this.objectBox.setToolTipText(I18n.tr((String)"The object preset you want to tag.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.objectBox, new GridBagConstraints(3, 3, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.nameLabel.setText(I18n.tr((String)"Name", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 4, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.nameField.setEnabled(false);
        this.nameField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ToolBoxView.this.nameField.selectAll();
            }
        });
        this.nameField.setToolTipText(I18n.tr((String)"Sets the name tag.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.nameField, new GridBagConstraints(3, 4, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.refLabel.setText(I18n.tr((String)"Reference", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refLabel, new GridBagConstraints(0, 5, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.refField.setEnabled(false);
        this.refField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ToolBoxView.this.refField.selectAll();
            }
        });
        this.refField.setToolTipText(I18n.tr((String)"Sets the referance tag.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.refField, new GridBagConstraints(3, 5, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.repeatOnLabel.setText(I18n.tr((String)"Repeat on", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.repeatOnLabel, new GridBagConstraints(0, 6, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.repeatOnField.setEnabled(false);
        this.repeatOnField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                ToolBoxView.this.repeatOnField.selectAll();
            }
        });
        this.repeatOnField.setToolTipText(I18n.tr((String)"Sets the repeat on tag when highway objects are selected. Please tag like this: -3-4 or -2--3 or 5-6 .", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.repeatOnField, new GridBagConstraints(3, 6, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.contentPanel.add((Component)this.separator2, new GridBagConstraints(0, 7, 0, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset1.setEnabled(false);
        this.contentPanel.add((Component)this.preset1, new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset2.setEnabled(false);
        this.contentPanel.add((Component)this.preset2, new GridBagConstraints(6, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset3.setEnabled(false);
        this.contentPanel.add((Component)this.preset3, new GridBagConstraints(6, 5, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.preset4.setEnabled(false);
        this.contentPanel.add((Component)this.preset4, new GridBagConstraints(6, 6, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.multiLabel.setText(I18n.tr((String)"Multipolygon", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.multiLabel, new GridBagConstraints(0, 8, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.multiOuterButton.setText(I18n.tr((String)"OUTER", (Object[])new Object[0]));
        this.multiOuterButton.setToolTipText(I18n.tr((String)"Creation-Tool for multipolygon with role: outer. To finish press the spacebar.", (Object[])new Object[0]));
        this.multiOuterButton.setEnabled(false);
        this.contentPanel.add((Component)this.multiOuterButton, new GridBagConstraints(3, 8, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 30), 0, 0));
        this.multiInnerButton.setText(I18n.tr((String)"INNER", (Object[])new Object[0]));
        this.multiInnerButton.setToolTipText(I18n.tr((String)"Creation-Tool for multipolygons with role: inner. To finish press spacebar. To add to relation select \"outer\" and press enter.", (Object[])new Object[0]));
        this.multiInnerButton.setEnabled(false);
        this.contentPanel.add((Component)this.multiInnerButton, new GridBagConstraints(6, 8, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.multiCheckBox.setToolTipText(I18n.tr((String)"Deactivate multipolygon function.", (Object[])new Object[0]));
        this.contentPanel.add((Component)this.multiCheckBox, new GridBagConstraints(9, 8, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.dialogPanel.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.applyButton.setText(I18n.tr((String)"Apply", (Object[])new Object[0]));
        this.applyButton.setToolTipText(I18n.tr((String)"Add selected tags and/or relations to obeject.", (Object[])new Object[0]));
        this.applyButton.setEnabled(false);
        this.buttonBar.add((Component)this.applyButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPanel.add((Component)this.buttonBar, "South");
        this.createLayout(this.dialogPanel, true, null);
    }

    public void setAllUiElementsEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.levelCheckBox.setEnabled(enabled);
        this.helpButton.setEnabled(enabled);
        this.objectBox.setEnabled(enabled);
        this.levelNameField.setEnabled(enabled);
        this.nameField.setEnabled(enabled);
        this.refField.setEnabled(enabled);
        this.levelNameField.setEnabled(enabled);
        this.repeatOnField.setEnabled(enabled);
        this.multiOuterButton.setEnabled(enabled);
        this.multiInnerButton.setEnabled(enabled);
        this.multiCheckBox.setEnabled(enabled);
        this.helpButton.setEnabled(enabled);
        this.addLevelButton.setEnabled(enabled);
        this.preset1.setEnabled(enabled);
        this.preset2.setEnabled(enabled);
        this.preset3.setEnabled(enabled);
        this.preset4.setEnabled(enabled);
        if (!enabled) {
            this.resetUiElements();
        }
    }

    public void setNRUiElementsEnabled(boolean enabled) {
        this.nameField.setEnabled(enabled);
        this.refField.setEnabled(enabled);
    }

    public void setROUiElementsEnabled(boolean enabled) {
        this.repeatOnField.setEnabled(enabled);
    }

    public void setLVLUiElementsEnabled(boolean enabled) {
        this.levelNameField.setEnabled(enabled);
        this.addLevelButton.setEnabled(enabled);
    }

    public void setMultiUiElementsEnabled(boolean enabled) {
        this.multiOuterButton.setEnabled(enabled);
        this.multiInnerButton.setEnabled(enabled);
        if (!enabled) {
            this.resetUiElements();
        }
    }

    public void reset() {
        this.setAllUiElementsEnabled(false);
    }

    public TagCatalog.IndoorObject getSelectedObject() {
        return (TagCatalog.IndoorObject)((Object)this.objectBox.getSelectedItem());
    }

    public String getLevelNameText() {
        return this.levelNameField.getText();
    }

    public void setLevelNameText(String name) {
        this.levelNameField.setText(name);
    }

    public String getNameText() {
        return this.nameField.getText();
    }

    public void setLevelLabel(String levelTag) {
        if (!this.getLevelCheckBoxStatus()) {
            if (!levelTag.equals("")) {
                this.levelLabel.setText(I18n.tr((String)"Working level: {0}", (Object[])new Object[]{levelTag}));
            } else {
                this.levelLabel.setText(I18n.tr((String)"Working level: NONE", (Object[])new Object[0]));
            }
        } else {
            this.levelLabel.setText(I18n.tr((String)"Working level: NONE", (Object[])new Object[0]));
        }
    }

    public boolean getLevelCheckBoxStatus() {
        return this.levelCheckBox.isSelected();
    }

    public String getRefText() {
        return this.refField.getText();
    }

    public String getRepeatOnText() {
        return this.repeatOnField.getText();
    }

    public void resetUiElements() {
        this.nameField.setText("");
        this.levelNameField.setText("");
        this.refField.setText("");
        this.repeatOnField.setText("");
        this.levelNameField.setText("");
    }

    public void setApplyButtonListener(ActionListener l) {
        this.applyButton.addActionListener(l);
    }

    public void setLevelCheckBoxListener(ItemListener l) {
        this.levelCheckBox.addItemListener(l);
    }

    public void setHelpButtonListener(ActionListener l) {
        this.helpButton.addActionListener(l);
    }

    public void setAddLevelButtonListener(ActionListener l) {
        this.addLevelButton.addActionListener(l);
    }

    public void setObjectItemListener(ItemListener l) {
        this.objectBox.addItemListener(l);
    }

    public void setOuterButtonListener(ActionListener l) {
        this.multiOuterButton.addActionListener(l);
    }

    public void setInnerButtonListener(ActionListener l) {
        this.multiInnerButton.addActionListener(l);
    }

    public void setMultiCheckBoxListener(ItemListener l) {
        this.multiCheckBox.addItemListener(l);
    }

    public void setPresetButtons(List<TagCatalog.IndoorObject> objects) {
        this.preset1.setIndoorObject(objects.get(0));
        this.preset2.setIndoorObject(objects.get(1));
        this.preset3.setIndoorObject(objects.get(2));
        this.preset4.setIndoorObject(objects.get(3));
    }

    public void setPreset1Listener(ActionListener l) {
        this.preset1.addActionListener(l);
    }

    public void setPreset2Listener(ActionListener l) {
        this.preset2.addActionListener(l);
    }

    public void setPreset3Listener(ActionListener l) {
        this.preset3.addActionListener(l);
    }

    public void setPreset4Listener(ActionListener l) {
        this.preset4.addActionListener(l);
    }

    public TagCatalog.IndoorObject getPreset1() {
        return this.preset1.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset2() {
        return this.preset2.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset3() {
        return this.preset3.getIndoorObject();
    }

    public TagCatalog.IndoorObject getPreset4() {
        return this.preset4.getIndoorObject();
    }
}

