/*
 * Decompiled with CFR 0.152.
 */
package model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Tag;

public class IndoorLevel {
    private static final Pattern RANGE = Pattern.compile("(-?[0-9]+)-(-?[0-9]+)");
    private Tag levelNumberTag;
    private Tag nameTag;

    public IndoorLevel(int levelNumber) {
        this.setLevelNumber(levelNumber);
    }

    public IndoorLevel(int levelNumber, String nameTag) {
        this.setLevelNumber(levelNumber);
        this.setNameTag(nameTag);
    }

    public Tag getLevelNumberTag() {
        return this.levelNumberTag;
    }

    public int getLevelNumber() {
        return Integer.parseInt(this.levelNumberTag.getValue());
    }

    public void setLevelNumber(int levelNumber) {
        this.levelNumberTag = new Tag("indoor:level", Integer.toString(levelNumber));
    }

    public Tag getNameTag() {
        return this.nameTag;
    }

    public String getName() {
        return this.nameTag.getValue();
    }

    public void setNameTag(String nameTag) {
        this.nameTag = new Tag("indoor:level:name", nameTag);
    }

    public boolean hasEmptyName() {
        return this.nameTag == null;
    }

    public static boolean isPartOfWorkingLevel(String vals, int level) {
        for (String val : vals.split(";")) {
            int secVal;
            int firstVal;
            Matcher m = RANGE.matcher(val);
            if (m.matches()) {
                firstVal = Integer.parseInt(m.group(1));
                secVal = Integer.parseInt(m.group(2));
            } else {
                secVal = firstVal = Integer.parseInt(val);
            }
            if (level < firstVal || level > secVal) continue;
            return true;
        }
        return false;
    }
}

