/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class DemuxInputStream
extends InputStream {
    private final InheritableThreadLocal<InputStream> m_streams = new InheritableThreadLocal();

    public InputStream bindStream(InputStream input) {
        InputStream oldValue = (InputStream)this.m_streams.get();
        this.m_streams.set(input);
        return oldValue;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable)this.m_streams.get());
    }

    @Override
    public int read() throws IOException {
        InputStream input = (InputStream)this.m_streams.get();
        if (null != input) {
            return input.read();
        }
        return -1;
    }
}

