/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractMapInfoReader
extends AbstractReader {
    protected static final String VERSION_1 = "1";
    protected static final String VERSION_2 = "2";
    protected static final String VERSION_300 = "300";
    protected static final String VERSION_450 = "450";
    protected static final String CHARSET_WINDOWS_LATIN = "WindowsLatin1";
    protected static final String CHARSET_WINDOWS_CYRILLIC = "WindowsCyrillic";
    protected static final String CHARSET_NEUTRAL = "Neutral";
    protected static final String CHARSET_MAC = "MacRoman";
    protected BufferedReader headerReader;
    protected String line;
    protected int lineNum = 0;
    protected String version;
    protected int numcolumns = -1;
    protected List<String> columns;

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    protected final File getDataFile(File headerFile, String extension) {
        String filename = headerFile.getName().substring(0, headerFile.getName().lastIndexOf(46));
        File dataFile = new File(headerFile.getParent() + File.separator + filename + extension.toUpperCase());
        if (!dataFile.exists()) {
            dataFile = new File(headerFile.getParent() + File.separator + filename + extension.toLowerCase());
        }
        return dataFile;
    }

    protected final BufferedReader getDataReader(File headerFile, String extension, Charset charset) throws IOException {
        File dataFile = this.getDataFile(headerFile, extension);
        return dataFile.exists() ? Files.newBufferedReader(dataFile.toPath(), charset) : null;
    }

    protected Charset parseCharset(String[] words) throws IllegalCharsetNameException, UnsupportedCharsetException {
        return this.parseCharset(words, 1);
    }

    protected Charset parseCharset(String[] words, int index) throws IllegalCharsetNameException, UnsupportedCharsetException {
        words[index] = words[index].replace("\"", "");
        if (words[index].equalsIgnoreCase(CHARSET_WINDOWS_LATIN)) {
            return Charset.forName("Cp1252");
        }
        if (words[index].equalsIgnoreCase(CHARSET_WINDOWS_CYRILLIC)) {
            return Charset.forName("Cp1251");
        }
        if (words[index].equalsIgnoreCase(CHARSET_NEUTRAL)) {
            return Charset.forName("ISO-8859-15");
        }
        if (words[index].equalsIgnoreCase(CHARSET_MAC)) {
            return Charset.forName(CHARSET_MAC);
        }
        Logging.error((String)("Line " + this.lineNum + ". Unknown charset detected: " + this.line));
        return Charset.forName(words[index]);
    }

    protected void parseVersion(String[] words) {
        this.version = words[1];
    }

    protected void parseColumns(String[] words) {
        this.columns = new ArrayList<String>();
        this.numcolumns = Integer.parseInt(words[1]);
    }

    protected final void parseHeader() throws IOException {
        while ((this.line = this.headerReader.readLine()) != null) {
            ++this.lineNum;
            while (this.line.contains("  ")) {
                this.line = this.line.replace("  ", " ");
            }
            String[] words = this.line.isEmpty() ? null : this.line.trim().split(" ");
            if (words == null || words.length <= 0) continue;
            this.parseHeaderLine(words);
        }
    }

    protected abstract void parseHeaderLine(String[] var1) throws IOException;
}

