/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public class ExternSheetRecord
extends StandardRecord {
    public static final short sid = 23;
    private List<RefSubRecord> _list = new ArrayList<RefSubRecord>();

    public ExternSheetRecord() {
    }

    public ExternSheetRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            RefSubRecord refSubRecord = new RefSubRecord(recordInputStream);
            this._list.add(refSubRecord);
        }
    }

    public void addREFRecord(RefSubRecord refSubRecord) {
        this._list.add(refSubRecord);
    }

    public int getNumOfREFRecords() {
        return this._list.size();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._list.size();
        stringBuffer.append("[EXTERNSHEET]\n");
        stringBuffer.append("   numOfRefs     = ").append(n).append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("refrec         #").append(i).append(": ");
            stringBuffer.append(this.getRef(i).toString());
            stringBuffer.append('\n');
        }
        stringBuffer.append("[/EXTERNSHEET]\n");
        return stringBuffer.toString();
    }

    @Override
    protected int getDataSize() {
        return 2 + this._list.size() * 6;
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        int n = this._list.size();
        littleEndianOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            this.getRef(i).serialize(littleEndianOutput);
        }
    }

    private RefSubRecord getRef(int n) {
        return this._list.get(n);
    }

    @Override
    public short getSid() {
        return 23;
    }

    public int getExtbookIndexFromRefIndex(int n) {
        return this.getRef(n).getExtBookIndex();
    }

    public int getFirstSheetIndexFromRefIndex(int n) {
        return this.getRef(n).getFirstSheetIndex();
    }

    public static ExternSheetRecord combine(ExternSheetRecord[] externSheetRecordArray) {
        ExternSheetRecord externSheetRecord = new ExternSheetRecord();
        for (int i = 0; i < externSheetRecordArray.length; ++i) {
            ExternSheetRecord externSheetRecord2 = externSheetRecordArray[i];
            int n = externSheetRecord2.getNumOfREFRecords();
            for (int j = 0; j < n; ++j) {
                externSheetRecord.addREFRecord(externSheetRecord2.getRef(j));
            }
        }
        return externSheetRecord;
    }

    private static final class RefSubRecord {
        public static final int ENCODED_SIZE = 6;
        private int _extBookIndex;
        private int _firstSheetIndex;
        private int _lastSheetIndex;

        public RefSubRecord(int n, int n2, int n3) {
            this._extBookIndex = n;
            this._firstSheetIndex = n2;
            this._lastSheetIndex = n3;
        }

        public RefSubRecord(RecordInputStream recordInputStream) {
            this(recordInputStream.readShort(), recordInputStream.readShort(), recordInputStream.readShort());
        }

        public int getExtBookIndex() {
            return this._extBookIndex;
        }

        public int getFirstSheetIndex() {
            return this._firstSheetIndex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("extBook=").append(this._extBookIndex);
            stringBuffer.append(" firstSheet=").append(this._firstSheetIndex);
            stringBuffer.append(" lastSheet=").append(this._lastSheetIndex);
            return stringBuffer.toString();
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._extBookIndex);
            littleEndianOutput.writeShort(this._firstSheetIndex);
            littleEndianOutput.writeShort(this._lastSheetIndex);
        }
    }
}

