/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ohe;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.ohe.ClockSystem;
import org.openstreetmap.josm.plugins.ohe.gui.OheDialogPanel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OhePlugin
extends Plugin {
    private final String[][] TAG_EDIT_STRINGS = new String[][]{{"opening_hours", ".*", "opening_hours"}, {"opening_hours:kitchen", ".*", "opening_hours:kitchen"}, {"collection_times", ".*", "collection_times"}, {"collection_times:local", ".*", "collection_times:local"}, {"service_times", ".*", "service_times"}, {"shop", ".*", "opening_hours"}, {"amenity", "post_box", "collection_times"}, {"amenity", ".*", "opening_hours"}, {"lit", ".*", "lit"}, {"highway", ".*", "lit"}};

    public OhePlugin(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)MainApplication.getMenu().dataMenu, (JosmAction)new OheMenuAction(), (boolean)false, (Integer)0);
    }

    class OheMenuAction
    extends JosmAction {
        private static final long serialVersionUID = 1456257438391417756L;

        OheMenuAction() {
            super(I18n.tr((String)"Edit opening hours", (Object[])new Object[0]), "opening_hours.png", I18n.tr((String)"Edit time-tag of selected element in a graphical interface", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:opening_hourseditor", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Edit opening hours", (Object[])new Object[0])}), (int)79, (int)5010), true);
        }

        protected void updateEnabledState() {
            if (this.getLayerManager().getEditDataSet() == null) {
                this.setEnabled(false);
            } else {
                this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
            }
        }

        protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
            this.setEnabled(selection != null && !selection.isEmpty());
        }

        public void actionPerformed(ActionEvent evt) {
            OsmDataLayer osmlayer = this.getLayerManager().getEditLayer();
            if (osmlayer == null) {
                return;
            }
            Collection selection = osmlayer.data.getSelected();
            HashMap<String, Integer> keyCount = new HashMap<String, Integer>();
            TreeMap valueCount = new TreeMap();
            for (Object osm : selection) {
                for (String key : osm.keySet()) {
                    String value = osm.get(key);
                    keyCount.put(key, keyCount.containsKey(key) ? (Integer)keyCount.get(key) + 1 : 1);
                    if (valueCount.containsKey(key)) {
                        Map map;
                        map.put(value, (map = (Map)valueCount.get(key)).containsKey(value) ? (Integer)map.get(value) + 1 : 1);
                        continue;
                    }
                    TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
                    treeMap.put(value, 1);
                    valueCount.put(key, treeMap);
                }
            }
            DefaultTableModel propertyData = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return String.class;
                }
            };
            propertyData.setColumnIdentifiers(new String[]{I18n.tr((String)"Key", (Object[])new Object[0]), I18n.tr((String)"Value", (Object[])new Object[0])});
            for (Map.Entry entry : valueCount.entrySet()) {
                int count = 0;
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    count += ((Integer)entry2.getValue()).intValue();
                }
                if (count < selection.size()) {
                    ((Map)entry.getValue()).put("", selection.size() - count);
                }
                propertyData.addRow(new Object[]{entry.getKey(), entry.getValue()});
            }
            final JTable propertyTable = new JTable(propertyData);
            propertyTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                    if (value == null) {
                        return this;
                    }
                    if (c instanceof JLabel) {
                        String str = null;
                        if (value instanceof String) {
                            str = (String)value;
                        } else if (value instanceof Map) {
                            Map v = (Map)value;
                            if (v.size() != 1) {
                                str = I18n.tr((String)"<different>", (Object[])new Object[0]);
                                c.setFont(c.getFont().deriveFont(2));
                            } else {
                                Map.Entry entry = v.entrySet().iterator().next();
                                str = (String)entry.getKey();
                            }
                        }
                        ((JLabel)c).setText(str);
                    }
                    return c;
                }
            });
            propertyTable.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(20, 30);
            jScrollPane.setViewportView(propertyTable);
            final JComboBox<String> newTagField = new JComboBox<String>(new String[]{"opening_hours", "opening_hours:kitchen", "collection_times", "collection_times:local", "service_times", "lit"});
            JRadioButton editButton = new JRadioButton(new AbstractAction(I18n.tr((String)"edit existing tag", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    propertyTable.setEnabled(true);
                    newTagField.setEnabled(false);
                }
            });
            JRadioButton jRadioButton = new JRadioButton(new AbstractAction(I18n.tr((String)"edit new tag", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    propertyTable.setEnabled(false);
                    newTagField.setEnabled(true);
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(jRadioButton);
            group.add(editButton);
            String preSelectedKey = "";
            block4: for (String[] pattern : OhePlugin.this.TAG_EDIT_STRINGS) {
                Pattern keyPattern = Pattern.compile(pattern[0]);
                Pattern valuePattern = Pattern.compile(pattern[1]);
                for (int i = 0; i < propertyData.getRowCount(); ++i) {
                    Matcher keyMatcher = keyPattern.matcher((String)propertyData.getValueAt(i, 0));
                    if (!keyMatcher.matches()) continue;
                    Object value = propertyData.getValueAt(i, 1);
                    if (value instanceof String && valuePattern.matcher((String)value).matches()) {
                        preSelectedKey = pattern[2];
                        break block4;
                    }
                    if (!(value instanceof Map)) continue;
                    for (String v : ((Map)value).keySet()) {
                        if (!valuePattern.matcher(v).matches()) continue;
                        preSelectedKey = pattern[2];
                        break block4;
                    }
                }
            }
            int preSelectedRow = -1;
            for (int i = 0; i < propertyData.getRowCount(); ++i) {
                if (!preSelectedKey.equals(propertyData.getValueAt(i, 0))) continue;
                preSelectedRow = i;
            }
            if (preSelectedRow != -1) {
                propertyTable.setEnabled(true);
                newTagField.setEnabled(false);
                propertyTable.setRowSelectionInterval(preSelectedRow, preSelectedRow);
                editButton.setSelected(true);
            } else {
                propertyTable.setEnabled(false);
                newTagField.setEnabled(true);
                newTagField.setSelectedItem(preSelectedKey);
                jRadioButton.setSelected(true);
            }
            ClockSystem clockSystem = ClockSystem.valueOf(Config.getPref().get("ohe.clocksystem", ClockSystem.getClockSystem(Locale.getDefault()).toString()));
            JCheckBox useTwelveHourClock = new JCheckBox(I18n.tr((String)"Display clock in 12h mode.", (Object[])new Object[0]), clockSystem == ClockSystem.TWELVE_HOURS);
            JPanel dlgPanel = new JPanel(new GridBagLayout());
            dlgPanel.add((Component)editButton, GBC.std().anchor(17));
            dlgPanel.add((Component)jScrollPane, GBC.eol().fill(1));
            dlgPanel.add((Component)jRadioButton, GBC.std().anchor(17));
            dlgPanel.add(newTagField, GBC.eol().fill(2));
            dlgPanel.add((Component)useTwelveHourClock, GBC.eol().fill(2).insets(0, 5, 0, 5));
            JOptionPane optionPane = new JOptionPane(dlgPanel, 3, 2);
            JDialog dlg = optionPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Choose key", (Object[])new Object[0]));
            dlg.pack();
            dlg.setResizable(true);
            dlg.setVisible(true);
            Object answer = optionPane.getValue();
            String keyToEdit = null;
            Object valuesToEdit = "";
            if (answer != null && answer != JOptionPane.UNINITIALIZED_VALUE && answer instanceof Integer && (Integer)answer == 0) {
                if (editButton.isSelected() && propertyTable.getSelectedRow() != -1) {
                    keyToEdit = (String)propertyData.getValueAt(propertyTable.getSelectedRow(), 0);
                    valuesToEdit = propertyData.getValueAt(propertyTable.getSelectedRow(), 1);
                } else if (jRadioButton.isSelected()) {
                    keyToEdit = newTagField.getSelectedItem().toString();
                }
            }
            if (keyToEdit == null) {
                return;
            }
            Config.getPref().put("ohe.clocksystem", (useTwelveHourClock.isSelected() ? ClockSystem.TWELVE_HOURS : ClockSystem.TWENTYFOUR_HOURS).toString());
            OheDialogPanel panel = new OheDialogPanel(OhePlugin.this, keyToEdit, valuesToEdit, useTwelveHourClock.isSelected() ? ClockSystem.TWELVE_HOURS : ClockSystem.TWENTYFOUR_HOURS);
            optionPane = new JOptionPane(panel, -1, 2);
            dlg = optionPane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Edit", (Object[])new Object[0]));
            dlg.setResizable(true);
            dlg.setVisible(true);
            String[] changedKeyValuePair = null;
            answer = optionPane.getValue();
            if (!(answer == null || answer == JOptionPane.UNINITIALIZED_VALUE || answer instanceof Integer && (Integer)answer != 0)) {
                changedKeyValuePair = panel.getChangedKeyValuePair();
            }
            if (changedKeyValuePair == null) {
                return;
            }
            String key = changedKeyValuePair[0].trim();
            String newkey = changedKeyValuePair[1].trim();
            String value = changedKeyValuePair[2].trim();
            if (value.equals("")) {
                value = null;
            }
            if (newkey.equals("")) {
                newkey = key;
                value = null;
            }
            if (key.equals(newkey) && I18n.tr((String)"<different>", (Object[])new Object[0]).equals(value)) {
                return;
            }
            if (key.equals(newkey) || value == null) {
                UndoRedoHandler.getInstance().add((Command)new ChangePropertyCommand(selection, newkey, value));
            } else {
                Vector<ChangePropertyCommand> commands = new Vector<ChangePropertyCommand>();
                commands.add(new ChangePropertyCommand(selection, key, null));
                if (value.equals(I18n.tr((String)"<different>", (Object[])new Object[0]))) {
                    HashMap map = new HashMap();
                    for (OsmPrimitive osmPrimitive : selection) {
                        String val = osmPrimitive.get(key);
                        if (val == null) continue;
                        if (map.containsKey(val)) {
                            ((Vector)map.get(val)).add(osmPrimitive);
                            continue;
                        }
                        Vector<OsmPrimitive> v = new Vector<OsmPrimitive>();
                        v.add(osmPrimitive);
                        map.put(val, v);
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        commands.add(new ChangePropertyCommand((Collection)entry.getValue(), newkey, (String)entry.getKey()));
                    }
                } else {
                    commands.add(new ChangePropertyCommand(selection, newkey, value));
                }
                UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.trn((String)"Change properties of up to {0} object", (String)"Change properties of up to {0} objects", (long)selection.size(), (Object[])new Object[]{selection.size()}), commands));
            }
        }
    }
}

