/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.util.ArrayList;
import java.util.Collections;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.BBox;

public class GpxFilter {
    private BBox bbox = new BBox(0.0, 0.0, 0.0, 0.0);
    private final GpxData data = new GpxData();

    public void initBboxFilter(BBox bbox) {
        this.bbox = bbox;
    }

    public void addGpxData(GpxData data) {
        for (IGpxTrack track : data.tracks) {
            ArrayList currentTrack = new ArrayList();
            for (IGpxTrackSegment segment : track.getSegments()) {
                ArrayList<WayPoint> currentSegment = new ArrayList<WayPoint>();
                for (WayPoint wp : segment.getWayPoints()) {
                    if (this.bbox.bounds(wp.getCoor())) {
                        currentSegment.add(wp);
                        continue;
                    }
                    if (currentSegment.size() <= 1) continue;
                    currentTrack.add(currentSegment);
                    currentSegment = new ArrayList();
                }
                if (currentSegment.size() <= 1) continue;
                currentTrack.add(currentSegment);
                currentSegment = new ArrayList();
            }
            this.data.tracks.add(new GpxTrack(currentTrack, Collections.emptyMap()));
        }
    }

    public GpxData getGpxData() {
        return this.data;
    }
}

