/*
 * Decompiled with CFR 0.152.
 */
package geochat;

import geochat.ChatMessage;
import geochat.ChatPaneManager;
import geochat.ChatServerConnection;
import geochat.ChatServerConnectionListener;
import geochat.GeoChatPopupAdapter;
import geochat.JPanelTextField;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class GeoChatPanel
extends ToggleDialog
implements ChatServerConnectionListener,
MapViewPaintable {
    private JTextField input;
    private JTabbedPane tabs;
    private JComponent noData;
    private JPanel loginPanel;
    private JPanel gcPanel;
    private ChatServerConnection connection;
    Map<String, LatLon> users;
    ChatPaneManager chatPanes;
    boolean userLayerActive;
    private final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm");

    public GeoChatPanel() {
        super(I18n.tr((String)"GeoChat", (Object[])new Object[0]), "geochat", I18n.tr((String)"Open GeoChat panel", (Object[])new Object[0]), null, 200, true);
        this.noData = new JLabel(I18n.tr((String)"Zoom in to see messages", (Object[])new Object[0]), 0);
        this.tabs = new JTabbedPane();
        this.tabs.addMouseListener(new GeoChatPopupAdapter(this));
        this.chatPanes = new ChatPaneManager(this, this.tabs);
        this.input = new JPanelTextField(){

            @Override
            protected void processEnter(String text) {
                GeoChatPanel.this.connection.postMessage(text, GeoChatPanel.this.chatPanes.getRecipient());
            }

            @Override
            protected String autoComplete(String word, boolean atStart) {
                return GeoChatPanel.this.autoCompleteUser(word, atStart);
            }
        };
        String defaultUserName = this.constructUserName();
        this.loginPanel = this.createLoginPanel(defaultUserName);
        this.gcPanel = new JPanel(new BorderLayout());
        this.gcPanel.add((Component)this.loginPanel, "Center");
        this.createLayout(this.gcPanel, false, null);
        this.users = new TreeMap<String, LatLon>();
        this.connection = ChatServerConnection.getInstance();
        this.connection.addListener(this);
        boolean autoLogin = Config.getPref().get("geochat.username", null) == null ? false : Config.getPref().getBoolean("geochat.autologin", true);
        this.connection.autoLoginWithDelay(autoLogin ? defaultUserName : null);
        this.updateTitleAlarm();
    }

    private String constructUserName() {
        String userName = Config.getPref().get("geochat.username", null);
        if (userName == null) {
            userName = UserIdentityManager.getInstance().getUserName();
        }
        if (userName == null) {
            userName = "";
        }
        if (userName.contains("@")) {
            userName = userName.substring(0, userName.indexOf(64));
        }
        userName = userName.replace(' ', '_');
        return userName;
    }

    private JPanel createLoginPanel(String defaultUserName) {
        JPanelTextField nameField = new JPanelTextField(){

            @Override
            protected void processEnter(String text) {
                GeoChatPanel.this.connection.login(text);
            }
        };
        ((JTextComponent)((Object)nameField)).setText(defaultUserName);
        JButton loginButton = new JButton(I18n.tr((String)"Login", (Object[])new Object[0]));
        loginButton.addActionListener(arg_0 -> this.lambda$createLoginPanel$0((JTextField)((Object)nameField), arg_0));
        ((JComponent)((Object)nameField)).setPreferredSize(new Dimension(((JTextField)((Object)nameField)).getPreferredSize().width, loginButton.getPreferredSize().height));
        JCheckBox autoLoginBox = new JCheckBox(I18n.tr((String)"Enable autologin", (Object[])new Object[0]), Config.getPref().getBoolean("geochat.autologin", true));
        autoLoginBox.addActionListener(e -> Config.getPref().putBoolean("geochat.autologin", autoLoginBox.isSelected()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)((Object)nameField), GBC.std().fill(2).insets(15, 0, 5, 0));
        panel.add((Component)loginButton, GBC.eol().fill(0).insets(0, 0, 15, 0));
        panel.add((Component)autoLoginBox, GBC.std().insets(15, 0, 15, 0));
        return panel;
    }

    protected void logout() {
        this.connection.logout();
    }

    public void destroy() {
        try {
            if (Config.getPref().getBoolean("geochat.logout.on.close", true)) {
                this.connection.removeListener(this);
                this.connection.bruteLogout();
            }
        }
        catch (IOException e) {
            Logging.warn((String)("Failed to logout from geochat server: " + e.getMessage()));
        }
        super.destroy();
    }

    private String autoCompleteUser(String word, boolean atStart) {
        String result = null;
        boolean singleUser = true;
        for (String user : this.users.keySet()) {
            int i;
            if (!user.startsWith(word)) continue;
            if (result == null) {
                result = user;
                continue;
            }
            singleUser = false;
            for (i = word.length(); i < result.length() && i < user.length() && result.charAt(i) == user.charAt(i); ++i) {
            }
            if (i >= result.length()) continue;
            result = result.substring(0, i);
        }
        return result == null ? null : (!singleUser ? result : (atStart ? result + ": " : result + " "));
    }

    public void paint(Graphics2D g, MapView mv, Bounds bbox) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AlphaComposite ac04 = AlphaComposite.getInstance(3, 0.4f);
        Composite ac10 = g2d.getComposite();
        Font font = g2d.getFont().deriveFont(1, g2d.getFont().getSize2D() + 2.0f);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        for (String user : this.users.keySet()) {
            int stringWidth = fm.stringWidth(user);
            int radius = stringWidth / 2 + 10;
            Point p = mv.getPoint(this.users.get(user));
            g2d.setComposite(ac04);
            g2d.setColor(Color.white);
            g2d.fillOval(p.x - radius, p.y - radius, radius * 2 + 1, radius * 2 + 1);
            g2d.setComposite(ac10);
            g2d.setColor(Color.black);
            g2d.drawString(user, p.x - stringWidth / 2, p.y + fm.getDescent());
        }
    }

    protected void updateTitleAlarm() {
        int alarmLevel;
        int n = alarmLevel = this.connection.isLoggedIn() ? this.chatPanes.getNotifyLevel() : 0;
        if (!this.isDialogInCollapsedView() && alarmLevel > 1) {
            alarmLevel = 1;
        }
        String comment = this.connection.isLoggedIn() ? I18n.trn((String)"{0} user", (String)"{0} users", (long)(this.users.size() + 1), (Object[])new Object[]{this.users.size() + 1}) : I18n.tr((String)"not logged in", (Object[])new Object[0]);
        String title = I18n.tr((String)"GeoChat", (Object[])new Object[0]);
        if (comment != null) {
            title = title + " (" + comment + ")";
        }
        String alarm = (alarmLevel <= 0 ? "" : (alarmLevel == 1 ? "* " : "!!! ")) + title;
        GuiHelper.runInEDT(() -> this.setTitle(alarm));
    }

    protected void setIsCollapsed(boolean val) {
        super.setIsCollapsed(val);
        this.chatPanes.setCollapsed(val);
        this.updateTitleAlarm();
    }

    @Override
    public void loggedIn(String userName) {
        Config.getPref().put("geochat.username", userName);
        if (this.gcPanel.getComponentCount() == 1) {
            GuiHelper.runInEDTAndWait(() -> {
                this.gcPanel.remove(0);
                this.gcPanel.add((Component)this.tabs, "Center");
                this.gcPanel.add((Component)this.input, "South");
            });
        }
        this.updateTitleAlarm();
    }

    @Override
    public void notLoggedIn(String reason) {
        if (reason != null) {
            GuiHelper.runInEDT(() -> new Notification(I18n.tr((String)"Failed to log in to GeoChat:", (Object[])new Object[0]) + '\n' + reason).show());
        } else if (this.gcPanel.getComponentCount() > 1) {
            this.gcPanel.removeAll();
            this.gcPanel.add((Component)this.loginPanel, "Center");
        }
        this.updateTitleAlarm();
    }

    @Override
    public void messageSendFailed(String reason) {
        GuiHelper.runInEDT(() -> new Notification(I18n.tr((String)"Failed to send message:", (Object[])new Object[0]) + '\n' + reason).show());
    }

    @Override
    public void statusChanged(boolean active) {
        this.tabs.setComponentAt(0, active ? this.chatPanes.getPublicChatComponent() : this.noData);
        this.repaint();
    }

    @Override
    public void updateUsers(Map<String, LatLon> newUsers) {
        for (String uname : this.users.keySet()) {
            if (newUsers.containsKey(uname)) continue;
            this.chatPanes.addLineToPublic(I18n.tr((String)"User {0} has left", (Object[])new Object[]{uname}), 1);
        }
        for (String uname : newUsers.keySet()) {
            if (this.users.containsKey(uname)) continue;
            this.chatPanes.addLineToPublic(I18n.tr((String)"User {0} is mapping nearby", (Object[])new Object[]{uname}), 1);
        }
        this.users = newUsers;
        this.updateTitleAlarm();
        if (this.userLayerActive && MainApplication.isDisplayingMapView()) {
            MainApplication.getMap().mapView.repaint();
        }
    }

    private void formatMessage(StringBuilder sb, ChatMessage msg) {
        sb.append("\n");
        sb.append('[').append(this.TIME_FORMAT.format(msg.getTime())).append("] ");
        sb.append(msg.getAuthor()).append(": ").append(msg.getMessage());
    }

    @Override
    public void receivedMessages(boolean replace, List<ChatMessage> messages) {
        if (replace) {
            this.chatPanes.clearPublicChatPane();
        }
        if (!messages.isEmpty()) {
            int alarm = 0;
            StringBuilder sb = new StringBuilder();
            for (ChatMessage msg : messages) {
                boolean important;
                boolean bl = important = msg.isIncoming() && this.containsName(msg.getMessage());
                if (msg.isIncoming() && alarm < 2) {
                    int n = alarm = important ? 2 : 1;
                }
                if (important) {
                    this.chatPanes.addLineToPublic(sb.toString());
                    sb.setLength(0);
                    this.formatMessage(sb, msg);
                    this.chatPanes.addLineToPublic(sb.toString(), 2);
                    sb.setLength(0);
                    continue;
                }
                this.formatMessage(sb, msg);
            }
            this.chatPanes.addLineToPublic(sb.toString());
            if (alarm > 0) {
                this.chatPanes.notify(null, alarm);
            }
        }
        if (replace) {
            this.showNearbyUsers();
        }
    }

    private void showNearbyUsers() {
        if (!this.users.isEmpty()) {
            StringBuilder sb = new StringBuilder(I18n.tr((String)"Users mapping nearby:", (Object[])new Object[0]));
            boolean first = true;
            for (String user : this.users.keySet()) {
                sb.append(first ? " " : ", ");
                sb.append(user);
            }
            this.chatPanes.addLineToPublic(sb.toString(), 1);
        }
    }

    private boolean containsName(String message) {
        String userName = this.connection.getUserName();
        int length = userName.length();
        int i = message.indexOf(userName);
        while (i >= 0) {
            if (!(i != 0 && Character.isJavaIdentifierPart(message.charAt(i - 1)) || i + length < message.length() && Character.isJavaIdentifierPart(message.charAt(i + length)))) {
                return true;
            }
            i = message.indexOf(userName, i + 1);
        }
        return false;
    }

    @Override
    public void receivedPrivateMessages(boolean replace, List<ChatMessage> messages) {
        if (replace) {
            this.chatPanes.closePrivateChatPanes();
        }
        for (ChatMessage msg : messages) {
            StringBuilder sb = new StringBuilder();
            this.formatMessage(sb, msg);
            this.chatPanes.addLineToChatPane(msg.isIncoming() ? msg.getAuthor() : msg.getRecipient(), sb.toString());
            if (!msg.isIncoming()) continue;
            this.chatPanes.notify(msg.getAuthor(), 2);
        }
    }

    private /* synthetic */ void lambda$createLoginPanel$0(JTextField nameField, ActionEvent e) {
        this.connection.login(nameField.getText());
    }
}

