/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.buildings_tools;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.CreateCircleAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.buildings_tools.AngleSnap;
import org.openstreetmap.josm.plugins.buildings_tools.BuildingsToolsPlugin;
import org.openstreetmap.josm.plugins.buildings_tools.ToolSettings;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

class Building {
    private final EastNorth[] en = new EastNorth[4];
    double meter;
    private double len;
    private double width;
    private double heading;
    private AngleSnap angleSnap = new AngleSnap();
    private Double drawingAngle;
    private static final double EQUAL_NODE_DIST_TOLERANCE = 1.0E-6;

    Building() {
    }

    public void clearAngleSnap() {
        this.angleSnap.clear();
        this.drawingAngle = null;
    }

    public void addAngleSnap(Node[] nodes) {
        this.drawingAngle = this.angleSnap.addSnap(nodes);
    }

    public void addAngleSnap(Way way) {
        this.angleSnap.addSnap(way);
        if (this.drawingAngle == null) {
            this.drawingAngle = this.angleSnap.getAngle();
        }
    }

    public double getLength() {
        return this.len;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isRectDrawing() {
        return this.drawingAngle != null && ToolSettings.getWidth() == 0.0 && ToolSettings.getLenStep() == 0.0 && ToolSettings.Shape.RECTANGLE == ToolSettings.getShape();
    }

    public Double getDrawingAngle() {
        return this.drawingAngle;
    }

    public void reset() {
        this.len = 0.0;
        for (int i = 0; i < 4; ++i) {
            this.en[i] = null;
        }
    }

    public EastNorth getPoint(int num) {
        return this.en[num];
    }

    private void updMetrics() {
        this.meter = 1.0 / Math.cos(Math.toRadians(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]).lat()));
        this.len = 0.0;
    }

    public void setBase(EastNorth base) {
        this.en[0] = base;
        this.updMetrics();
    }

    private double projection1(EastNorth p) {
        EastNorth vec = p.subtract(this.en[0]);
        return (Math.sin(this.heading) * vec.east() + Math.cos(this.heading) * vec.north()) / this.meter;
    }

    private double projection2(EastNorth p) {
        EastNorth vec = p.subtract(this.en[0]);
        return (Math.cos(this.heading) * vec.east() - Math.sin(this.heading) * vec.north()) / this.meter;
    }

    private void updatePos() {
        if (this.len == 0.0) {
            return;
        }
        EastNorth p1 = this.en[0];
        this.en[1] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter);
        if (ToolSettings.Shape.RECTANGLE == ToolSettings.getShape()) {
            this.en[2] = new EastNorth(p1.east() + Math.sin(this.heading) * this.len * this.meter + Math.cos(this.heading) * this.width * this.meter, p1.north() + Math.cos(this.heading) * this.len * this.meter - Math.sin(this.heading) * this.width * this.meter);
            this.en[3] = new EastNorth(p1.east() + Math.cos(this.heading) * this.width * this.meter, p1.north() - Math.sin(this.heading) * this.width * this.meter);
        }
    }

    private void setLengthWidth(double length, double width) {
        this.len = length;
        this.width = width;
        this.updatePos();
    }

    public void setWidth(EastNorth p3) {
        this.width = this.projection2(p3);
        this.updatePos();
    }

    public void setPlace(EastNorth p2, double width, double lenstep, boolean ignoreConstraints) {
        if (this.en[0] == null) {
            throw new IllegalStateException("setPlace() called without the base point");
        }
        this.heading = this.en[0].heading(p2);
        if (!ignoreConstraints) {
            this.heading = this.angleSnap.snapAngle(this.heading);
        }
        this.width = width;
        this.len = this.projection1(p2);
        if (lenstep > 0.0 && !ignoreConstraints) {
            this.len = (double)Math.round(this.len / lenstep) * lenstep;
        }
        this.updatePos();
        MainApplication.getMap().statusLine.setHeading(Math.toDegrees(this.heading));
        if (this.drawingAngle != null && !ignoreConstraints) {
            double ang = Math.toDegrees(this.heading - this.drawingAngle);
            if (ang < 0.0) {
                ang += 360.0;
            }
            if (ang > 360.0) {
                ang -= 360.0;
            }
            MainApplication.getMap().statusLine.setAngle(ang);
        }
    }

    public void setPlaceCircle(EastNorth p2, double width, boolean ignoreConstraints) {
        if (this.en[0] == null) {
            throw new IllegalStateException("setPlace() called without the base point");
        }
        this.heading = this.en[0].heading(p2);
        if (!ignoreConstraints) {
            this.heading = this.angleSnap.snapAngle(this.heading);
        }
        this.len = width;
        this.updatePos();
    }

    public void setPlaceRect(EastNorth p2) {
        if (this.en[0] == null) {
            throw new IllegalStateException("SetPlaceRect() called without the base point");
        }
        if (!this.isRectDrawing()) {
            throw new IllegalStateException("Invalid drawing mode");
        }
        this.heading = this.drawingAngle;
        this.setLengthWidth(this.projection1(p2), this.projection2(p2));
        MainApplication.getMap().statusLine.setHeading(Math.toDegrees(this.heading));
    }

    public void angFix(EastNorth point) {
        EastNorth en3 = this.en[2];
        EastNorth mid = this.en[0].getCenter(en3);
        double radius = en3.distance(mid);
        this.heading = mid.heading(point);
        this.heading = this.en[0].heading(mid.add(Math.sin(this.heading) * radius, Math.cos(this.heading) * radius));
        this.setLengthWidth(this.projection1(en3), this.projection2(en3));
        this.en[2] = en3;
    }

    public void paint(Graphics2D g, MapView mv) {
        if (this.len == 0.0) {
            return;
        }
        GeneralPath b = new GeneralPath();
        Point pp1 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[0]));
        Point pp2 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[1]));
        b.moveTo(pp1.x, pp1.y);
        b.lineTo(pp2.x, pp2.y);
        if (ToolSettings.Shape.RECTANGLE == ToolSettings.getShape()) {
            Point pp3 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[2]));
            Point pp4 = mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(this.en[3]));
            b.lineTo(pp3.x, pp3.y);
            b.lineTo(pp4.x, pp4.y);
        }
        b.lineTo(pp1.x, pp1.y);
        g.draw(b);
    }

    private static Node findNode(EastNorth pos) {
        MapView mv = MainApplication.getMap().mapView;
        Node n = mv.getNearestNode(mv.getPoint(BuildingsToolsPlugin.eastNorth2latlon(pos)), OsmPrimitive::isSelectable);
        if (n == null) {
            return null;
        }
        return n.getEastNorth().distance(pos) <= 1.0E-6 ? n : null;
    }

    private static Node getAddressNode(Way w) {
        BBox bbox = w.getBBox();
        LinkedList<Node> nodes = new LinkedList<Node>();
        Area area = Geometry.getArea((List)w.getNodes());
        for (Node n : MainApplication.getLayerManager().getEditDataSet().searchNodes(bbox)) {
            EastNorth enTest;
            if (!n.isUsable() || !Building.findUsableTag((OsmPrimitive)n) || !area.contains((enTest = n.getEastNorth()).getX(), enTest.getY())) continue;
            boolean useNode = true;
            for (OsmPrimitive p : n.getReferrers()) {
                if (p.getType() != OsmPrimitiveType.WAY) continue;
                useNode = false;
                break;
            }
            if (!useNode) continue;
            nodes.add(n);
        }
        if (nodes.size() != 1) {
            return null;
        }
        return (Node)nodes.get(0);
    }

    static boolean findUsableTag(OsmPrimitive p) {
        for (String key : p.getKeys().keySet()) {
            if (!"building".equals(key) && !key.startsWith("addr:")) continue;
            return true;
        }
        return false;
    }

    public Way createCircle() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        Collection selectedPrimitives = ds.getAllSelected();
        ds.clearSelection();
        if (this.len == 0.0) {
            return null;
        }
        boolean[] created = new boolean[2];
        Node[] nodes = new Node[2];
        for (int i = 0; i < 2; ++i) {
            Node n = Building.findNode(this.en[i]);
            if (n == null) {
                nodes[i] = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en[i]));
                created[i] = true;
            } else {
                nodes[i] = n;
                created[i] = false;
            }
            if (!nodes[i].isOutSideWorld()) continue;
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Cannot place building outside of the world.", (Object[])new Object[0]));
            return null;
        }
        Way w = new Way();
        w.addNode(nodes[0]);
        w.addNode(nodes[1]);
        LinkedList<Command> addNodesCmd = new LinkedList<Command>();
        for (int i = 0; i < 2; ++i) {
            if (!created[i]) continue;
            AddCommand addNode = new AddCommand(ds, (OsmPrimitive)nodes[i]);
            addNodesCmd.add((Command)addNode);
        }
        Building.snapBuildings(w, nodes, addNodesCmd);
        if (!addNodesCmd.isEmpty()) {
            SequenceCommand addNodes = new SequenceCommand(I18n.tr((String)"Add nodes for building", (Object[])new Object[0]), addNodesCmd);
            UndoRedoHandler.getInstance().add((Command)addNodes);
        }
        ds.addSelected((Collection)w.getNodes());
        int oldNumWays = ds.getWays().size();
        CreateCircleAction action = new CreateCircleAction();
        action.setEnabled(true);
        action.actionPerformed(null);
        ds.clearSelection();
        ds.addSelected(selectedPrimitives);
        if (oldNumWays < ds.getWays().size()) {
            ArrayList ways = new ArrayList(ds.getWays());
            Collections.sort(ways);
            w = (Way)ways.get(0);
            Building.addAddress(w, null);
            return w;
        }
        if (!addNodesCmd.isEmpty()) {
            UndoRedoHandler.getInstance().undo(1);
        }
        return null;
    }

    public Way createRectangle(boolean ctrl) {
        if (this.len == 0.0) {
            return null;
        }
        boolean[] created = new boolean[4];
        Node[] nodes = new Node[4];
        boolean snap = !ctrl;
        for (int i = 0; i < 4; ++i) {
            Node n = null;
            if (snap) {
                n = Building.findNode(this.en[i]);
            }
            if (n == null) {
                nodes[i] = new Node(BuildingsToolsPlugin.eastNorth2latlon(this.en[i]));
                created[i] = true;
            } else {
                nodes[i] = n;
                created[i] = false;
            }
            if (!nodes[i].isOutSideWorld()) continue;
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Cannot place building outside of the world.", (Object[])new Object[0]));
            return null;
        }
        Way w = new Way();
        w.addNode(nodes[0]);
        if (this.projection2(this.en[2]) > 0.0 ^ this.len < 0.0) {
            w.addNode(nodes[1]);
            w.addNode(nodes[2]);
            w.addNode(nodes[3]);
        } else {
            w.addNode(nodes[3]);
            w.addNode(nodes[2]);
            w.addNode(nodes[1]);
        }
        w.addNode(nodes[0]);
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        LinkedList<Command> cmds = new LinkedList<Command>();
        for (int i = 0; i < 4; ++i) {
            if (!created[i]) continue;
            cmds.add((Command)new AddCommand(ds, (OsmPrimitive)nodes[i]));
        }
        cmds.add((Command)new AddCommand(ds, (OsmPrimitive)w));
        Building.addAddress(w, cmds);
        if (snap) {
            Building.snapBuildings(w, nodes, cmds);
        }
        SequenceCommand c = new SequenceCommand(I18n.tr((String)"Create building", (Object[])new Object[0]), cmds);
        UndoRedoHandler.getInstance().add((Command)c);
        return w;
    }

    private static void snapBuildings(Way w, Node[] nodes, Collection<Command> cmds) {
        List wayNodes = w.getNodes();
        LinkedHashSet<Way> others = new LinkedHashSet<Way>();
        MapView mv = MainApplication.getMap().mapView;
        for (Node n : nodes) {
            Way w2 = mv.getNearestWay(mv.getPoint(n), OsmPrimitive::isSelectable);
            if (w2 == null || w2.get("building") == null) continue;
            others.add(w2);
        }
        for (Way other : others) {
            Building.snapToWay(wayNodes, other.getNodes());
            w.setNodes(wayNodes);
        }
        for (Way other : others) {
            List otherNodes = other.getNodes();
            Building.snapToWay(otherNodes, Arrays.asList(nodes));
            if (otherNodes.size() == other.getNodesCount()) continue;
            Way newWay = new Way(other);
            newWay.setNodes(otherNodes);
            cmds.add((Command)new ChangeCommand((OsmPrimitive)other, (OsmPrimitive)newWay));
        }
    }

    private static void snapToWay(List<Node> wayNodes, Collection<Node> otherNodes) {
        block0: for (int i = 0; i < wayNodes.size(); ++i) {
            Node n0 = wayNodes.get(i);
            Node n1 = wayNodes.get(i + 1 == wayNodes.size() ? 0 : i + 1);
            for (Node n2 : otherNodes) {
                EastNorth x;
                if (n2 == n0 || n2 == n1 || !((x = Geometry.closestPointToSegment((EastNorth)n0.getEastNorth(), (EastNorth)n1.getEastNorth(), (EastNorth)n2.getEastNorth())).distance(n2.getEastNorth()) <= 1.0E-6) || wayNodes.contains(n2)) continue;
                wayNodes.add(i + 1, n2);
                --i;
                continue block0;
            }
        }
    }

    private static void addAddress(Way w, Collection<Command> cmdList) {
        Node addrNode;
        if (ToolSettings.PROP_USE_ADDR_NODE.get().booleanValue() && (addrNode = Building.getAddressNode(w)) != null) {
            LinkedList<Object> addressCmds = cmdList != null ? cmdList : new LinkedList<Object>();
            for (Map.Entry entry : addrNode.getKeys().entrySet()) {
                w.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (OsmPrimitive p : addrNode.getReferrers()) {
                Relation r = (Relation)p;
                Relation rnew = new Relation(r);
                for (int i = 0; i < r.getMembersCount(); ++i) {
                    RelationMember member = r.getMember(i);
                    if (!addrNode.equals((Object)member.getMember())) continue;
                    rnew.removeMember(i);
                    rnew.addMember(i, new RelationMember(member.getRole(), (OsmPrimitive)w));
                }
                addressCmds.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)rnew));
            }
            addressCmds.add(new DeleteCommand((OsmPrimitive)addrNode));
            if (cmdList == null) {
                SequenceCommand c = new SequenceCommand(I18n.tr((String)"Add address for building", (Object[])new Object[0]), addressCmds);
                UndoRedoHandler.getInstance().add((Command)c);
            }
        }
    }
}

