/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate;

import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.piclayer.actions.GenericPicTransformAction;
import org.openstreetmap.josm.plugins.piclayer.actions.transform.autocalibrate.AutoCalibrateHandler;
import org.openstreetmap.josm.plugins.piclayer.gui.autocalibrate.CalibrationWindow;
import org.openstreetmap.josm.plugins.piclayer.layer.PicLayerAbstract;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AutoCalibratePictureAction
extends GenericPicTransformAction {
    private static final Logger logger = Logger.getLogger(AutoCalibratePictureAction.class.getName());
    private AutoCalibrateHandler calibrationHandler;
    private CalibrationWindow calibrationWindow;

    public AutoCalibratePictureAction() {
        super(I18n.tr((String)"PicLayer auto calibration", (Object[])new Object[0]), I18n.tr((String)"Calibrated", (Object[])new Object[0]), "autoCalibrate", I18n.tr((String)"Calibrate picture with outline", (Object[])new Object[0]), ImageProvider.getCursor((String)"crosshair", null));
        logger.info(this.getClass().getName() + " has been created.");
        this.calibrationHandler = new AutoCalibrateHandler();
    }

    @Override
    protected void doAction(MouseEvent e) {
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.updateDrawPoints(true);
        this.currentLayer = (PicLayerAbstract)MainApplication.getLayerManager().getActiveLayer();
        if (this.currentLayer != null) {
            this.calibrationHandler.prepare(this.currentLayer);
            this.calibrationWindow = this.calibrationHandler.getMainWindow();
            this.calibrationWindow.setVisible(true);
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.updateDrawPoints(false);
    }
}

