/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.dialogs;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.plugins.graphview.core.access.AccessType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.PreferenceAccessParameters;
import org.openstreetmap.josm.plugins.graphview.plugin.preferences.VehiclePropertyStringParser;
import org.openstreetmap.josm.tools.I18n;

public class AccessParameterDialog
extends JDialog {
    private static final Map<VehiclePropertyType<Float>, String> FLOAT_PROPERTIES = new LinkedHashMap<VehiclePropertyType<Float>, String>();
    private static final Collection<Character> FORBIDDEN_CHARS;
    private boolean existingBookmark = false;
    private final Collection<String> existingBookmarkNames;
    private final BookmarkAction okAction;
    private final BookmarkNamePanel bookmarkNamePanel;
    private final AccessClassPanel accessClassPanel;
    private final AccessTypesPanel accessTypesPanel;
    private final VehiclePropertiesPanel vehiclePropertiesPanel;
    private final RoadQualityPanel roadQualityPanel;

    static {
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.HEIGHT, I18n.tr((String)"height (m)", (Object[])new Object[0]));
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.WIDTH, I18n.tr((String)"width (m)", (Object[])new Object[0]));
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.LENGTH, I18n.tr((String)"length (m)", (Object[])new Object[0]));
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.SPEED, I18n.tr((String)"speed (km/h)", (Object[])new Object[0]));
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.WEIGHT, I18n.tr((String)"weight (t)", (Object[])new Object[0]));
        FLOAT_PROPERTIES.put(VehiclePropertyTypes.AXLELOAD, I18n.tr((String)"axleload (t)", (Object[])new Object[0]));
        FORBIDDEN_CHARS = Arrays.asList(Character.valueOf(','), Character.valueOf(';'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('='), Character.valueOf('|'));
    }

    public AccessParameterDialog(Frame owner, boolean existingBookmark, String initialName, Collection<String> existingBookmarkNames, PreferenceAccessParameters initialAccessParameters, BookmarkAction okAction) {
        super(owner, I18n.tr((String)"Edit access parameters", (Object[])new Object[0]), true);
        this.existingBookmark = existingBookmark;
        this.existingBookmarkNames = existingBookmarkNames;
        this.okAction = okAction;
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.bookmarkNamePanel = new BookmarkNamePanel(initialName);
        gbc.gridy = 0;
        layout.setConstraints(this.bookmarkNamePanel, gbc);
        this.add(this.bookmarkNamePanel);
        this.accessClassPanel = new AccessClassPanel(initialAccessParameters);
        gbc.gridy = 1;
        layout.setConstraints(this.accessClassPanel, gbc);
        this.add(this.accessClassPanel);
        this.accessTypesPanel = new AccessTypesPanel(initialAccessParameters);
        gbc.gridy = 2;
        layout.setConstraints(this.accessTypesPanel, gbc);
        this.add(this.accessTypesPanel);
        this.vehiclePropertiesPanel = new VehiclePropertiesPanel(initialAccessParameters);
        gbc.gridy = 3;
        layout.setConstraints(this.vehiclePropertiesPanel, gbc);
        this.add(this.vehiclePropertiesPanel);
        this.roadQualityPanel = new RoadQualityPanel(initialAccessParameters);
        gbc.gridy = 4;
        layout.setConstraints(this.roadQualityPanel, gbc);
        this.add(this.roadQualityPanel);
        OkCancelPanel okCancelPanel = new OkCancelPanel();
        gbc.gridy = 5;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        layout.setConstraints(okCancelPanel, gbc);
        this.add(okCancelPanel);
        this.pack();
    }

    private PreferenceAccessParameters getAccessParameters() {
        String accessClass = this.accessClassPanel.getAccessClass();
        Collection<AccessType> usableAccessTypes = this.accessTypesPanel.getUsableAccessTypes();
        Map<VehiclePropertyType<?>, String> vehiclePropertyStrings = this.vehiclePropertiesPanel.getVehiclePropertyStrings();
        Map<VehiclePropertyType<?>, String> additionalVehiclePropertyStrings = this.roadQualityPanel.getVehiclePropertyStrings();
        if (accessClass != null && usableAccessTypes != null && vehiclePropertyStrings != null && additionalVehiclePropertyStrings != null) {
            vehiclePropertyStrings.putAll(additionalVehiclePropertyStrings);
            try {
                return new PreferenceAccessParameters(accessClass, usableAccessTypes, vehiclePropertyStrings);
            }
            catch (VehiclePropertyStringParser.PropertyValueSyntaxException e) {
                JOptionPane.showMessageDialog(this, e.getMessage());
                return null;
            }
        }
        return null;
    }

    private static class AccessClassPanel
    extends JPanel {
        private final JTextField accessClassTextField;

        AccessClassPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Access class", (Object[])new Object[0])));
            this.setLayout(new BoxLayout(this, 0));
            this.accessClassTextField = new JTextField(initialParameters.getAccessClass());
            this.add(this.accessClassTextField);
        }

        public String getAccessClass() {
            String name = this.accessClassTextField.getText();
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char nameChar = cArray[n2];
                if (FORBIDDEN_CHARS.contains(Character.valueOf(nameChar))) {
                    JOptionPane.showMessageDialog(this, I18n.tr((String)"Access class must not contain ''{0}''!", (Object[])new Object[]{Character.valueOf(nameChar)}));
                    return null;
                }
                ++n2;
            }
            return name;
        }
    }

    private static class AccessTypesPanel
    extends JPanel {
        private static final int COLS = 4;
        private final Map<AccessType, JCheckBox> accessTypeCheckBoxes = new EnumMap<AccessType, JCheckBox>(AccessType.class);

        AccessTypesPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Access types", (Object[])new Object[0])));
            this.setLayout(new GridLayout((3 + AccessType.values().length) / 4, 4));
            AccessType[] accessTypeArray = AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessType accessType = accessTypeArray[n2];
                JCheckBox checkBox = new JCheckBox(accessType.toString());
                checkBox.setSelected(initialParameters.getAccessTypeUsable(accessType));
                this.accessTypeCheckBoxes.put(accessType, checkBox);
                this.add(checkBox);
                ++n2;
            }
        }

        public Collection<AccessType> getUsableAccessTypes() {
            LinkedList<AccessType> usableAccessTypes = new LinkedList<AccessType>();
            AccessType[] accessTypeArray = AccessType.values();
            int n = accessTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessType accessType = accessTypeArray[n2];
                if (this.accessTypeCheckBoxes.get((Object)accessType).isSelected()) {
                    usableAccessTypes.add(accessType);
                }
                ++n2;
            }
            return usableAccessTypes;
        }
    }

    public static interface BookmarkAction {
        public void execute(String var1, PreferenceAccessParameters var2);
    }

    private class BookmarkNamePanel
    extends JPanel {
        private final JTextField bookmarkNameTextField;

        BookmarkNamePanel(String initialName) {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Bookmark name", (Object[])new Object[0])));
            this.setLayout(new BoxLayout(this, 0));
            this.bookmarkNameTextField = new JTextField(initialName);
            this.add(this.bookmarkNameTextField);
        }

        public String getBookmarkName() {
            String name = this.bookmarkNameTextField.getText();
            if (AccessParameterDialog.this.existingBookmarkNames.contains(name)) {
                JOptionPane.showMessageDialog(this, I18n.tr((String)"Bookmark name already exists!", (Object[])new Object[0]));
                return null;
            }
            char[] cArray = name.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char nameChar = cArray[n2];
                if (FORBIDDEN_CHARS.contains(Character.valueOf(nameChar))) {
                    JOptionPane.showMessageDialog(this, I18n.tr((String)"Bookmark name must not contain ''{0}''!", (Object[])new Object[]{Character.valueOf(nameChar)}));
                    return null;
                }
                ++n2;
            }
            return name;
        }
    }

    private class OkCancelPanel
    extends JPanel {
        OkCancelPanel() {
            new BoxLayout(this, 0);
            JButton okButton = new JButton(AccessParameterDialog.this.existingBookmark ? I18n.tr((String)"Change bookmark", (Object[])new Object[0]) : I18n.tr((String)"Create bookmark", (Object[])new Object[0]));
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PreferenceAccessParameters parameters;
                    String bookmarkName = AccessParameterDialog.this.bookmarkNamePanel.getBookmarkName();
                    if (bookmarkName != null && (parameters = AccessParameterDialog.this.getAccessParameters()) != null) {
                        AccessParameterDialog.this.okAction.execute(bookmarkName, parameters);
                        AccessParameterDialog.this.dispose();
                    }
                }
            });
            this.add(okButton);
            JButton cancelButton = new JButton(I18n.tr((String)"Cancel", (Object[])new Object[0]));
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AccessParameterDialog.this.dispose();
                }
            });
            this.add(cancelButton);
        }
    }

    private static class RoadQualityPanel
    extends JPanel {
        private JTextField inclineUpTextField;
        private JTextField inclineDownTextField;
        private JTextField surfaceTextField;
        private JTextField tracktypeTextField;

        RoadQualityPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Road requirements", (Object[])new Object[0])));
            this.setLayout(new GridLayout(4, 2));
            JLabel inclineUpLabel = new JLabel(I18n.tr((String)"Max. incline up (%, pos.)", (Object[])new Object[0]));
            inclineUpLabel.setToolTipText(I18n.tr((String)"Maximum incline the vehicle can go up", (Object[])new Object[0]));
            this.add(inclineUpLabel);
            this.inclineUpTextField = new JTextField();
            String vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_INCLINE_UP);
            if (vehiclePropertyString != null) {
                this.inclineUpTextField.setText(vehiclePropertyString);
            }
            this.inclineUpTextField.setToolTipText(I18n.tr((String)"Maximum incline the vehicle can go up", (Object[])new Object[0]));
            this.add(this.inclineUpTextField);
            JLabel inclineDownLabel = new JLabel(I18n.tr((String)"Max. incline down (%, pos.)", (Object[])new Object[0]));
            inclineDownLabel.setToolTipText(I18n.tr((String)"Maximum incline the vehicle can go down", (Object[])new Object[0]));
            this.add(inclineDownLabel);
            this.inclineDownTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_INCLINE_DOWN);
            if (vehiclePropertyString != null) {
                this.inclineDownTextField.setText(vehiclePropertyString);
            }
            this.inclineDownTextField.setToolTipText(I18n.tr((String)"Maximum incline the vehicle can go down", (Object[])new Object[0]));
            this.add(this.inclineDownTextField);
            JLabel surfaceLabel = new JLabel(I18n.tr((String)"Surface blacklist", (Object[])new Object[0]));
            surfaceLabel.setToolTipText(I18n.tr((String)"List of surfaces the vehicle cannot use, values are separated by semicolons (;)", (Object[])new Object[0]));
            this.add(surfaceLabel);
            this.surfaceTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.SURFACE_BLACKLIST);
            if (vehiclePropertyString != null) {
                this.surfaceTextField.setText(vehiclePropertyString);
            }
            this.surfaceTextField.setToolTipText(I18n.tr((String)"List of surfaces the vehicle cannot use, values are separated by semicolons (;)", (Object[])new Object[0]));
            this.add(this.surfaceTextField);
            JLabel tracktypeLabel = new JLabel(I18n.tr((String)"max. tracktype grade", (Object[])new Object[0]));
            tracktypeLabel.setToolTipText(I18n.tr((String)"Worst tracktype (1-5) the vehicle can still use, 0 for none", (Object[])new Object[0]));
            this.add(tracktypeLabel);
            this.tracktypeTextField = new JTextField();
            vehiclePropertyString = initialParameters.getVehiclePropertyString(VehiclePropertyTypes.MAX_TRACKTYPE);
            if (vehiclePropertyString != null) {
                this.tracktypeTextField.setText(vehiclePropertyString);
            }
            this.tracktypeTextField.setToolTipText(I18n.tr((String)"Worst tracktype (1-5) the vehicle can still use, 0 for none", (Object[])new Object[0]));
            this.add(this.tracktypeTextField);
        }

        public Map<VehiclePropertyType<?>, String> getVehiclePropertyStrings() {
            String tracktypeString;
            String surfaceString;
            String incDownString;
            HashMap vehiclePropertyStrings = new HashMap();
            String incUpString = this.inclineUpTextField.getText();
            if (incUpString.trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_INCLINE_UP, incUpString);
            }
            if ((incDownString = this.inclineDownTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_INCLINE_DOWN, incDownString);
            }
            if ((surfaceString = this.surfaceTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.SURFACE_BLACKLIST, surfaceString);
            }
            if ((tracktypeString = this.tracktypeTextField.getText()).trim().length() > 0) {
                vehiclePropertyStrings.put(VehiclePropertyTypes.MAX_TRACKTYPE, tracktypeString);
            }
            return vehiclePropertyStrings;
        }
    }

    private static class VehiclePropertiesPanel
    extends JPanel {
        private static final int COLS = 2;
        private final Map<VehiclePropertyType<Float>, JTextField> floatPropertyTextFields = new HashMap<VehiclePropertyType<Float>, JTextField>();

        VehiclePropertiesPanel(PreferenceAccessParameters initialParameters) {
            this.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Vehicle properties", (Object[])new Object[0])));
            this.setLayout(new GridLayout((1 + FLOAT_PROPERTIES.size()) / 2, 4));
            for (VehiclePropertyType vehicleProperty : FLOAT_PROPERTIES.keySet()) {
                JLabel label = new JLabel((String)FLOAT_PROPERTIES.get(vehicleProperty));
                this.add(label);
                JTextField textField = new JTextField();
                String vehiclePropertyString = initialParameters.getVehiclePropertyString(vehicleProperty);
                if (vehiclePropertyString != null) {
                    textField.setText(vehiclePropertyString);
                }
                this.floatPropertyTextFields.put(vehicleProperty, textField);
                this.add(textField);
            }
        }

        public Map<VehiclePropertyType<?>, String> getVehiclePropertyStrings() {
            HashMap vehiclePropertyStrings = new HashMap();
            for (VehiclePropertyType<Float> vehicleProperty : this.floatPropertyTextFields.keySet()) {
                String textFieldContent = this.floatPropertyTextFields.get(vehicleProperty).getText();
                if (textFieldContent.trim().length() <= 0) continue;
                vehiclePropertyStrings.put(vehicleProperty, textFieldContent);
            }
            return vehiclePropertyStrings;
        }
    }
}

