/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class GpxServerReader
extends OsmConnection {
    public GpxData loadGpx(long id) {
        String urlString = String.valueOf(OsmApi.getOsmApi().getBaseUrl()) + "gpx/" + id + "/data";
        try {
            HttpClient client = HttpClient.create((URL)new URL(urlString));
            this.addAuth(client);
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream in = client.connect().uncompressAccordingToContentDisposition(true).getContent();){
                GpxReader r = new GpxReader(in);
                boolean parsedProperly = r.parse(true);
                if (!parsedProperly) {
                    JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error occurred while parsing gpx file {0}. Only a part of the file will be available.", (Object[])new Object[]{urlString}));
                }
                return r.getGpxData();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | OsmTransferException e) {
            Logging.warn((Throwable)e);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error fetching URL {0}", (Object[])new Object[]{urlString}));
            return null;
        }
        catch (SAXException e) {
            Logging.warn((Throwable)e);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error parsing data from URL {0}", (Object[])new Object[]{urlString}));
            return null;
        }
    }
}

