/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.directdownload;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JMenu;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.ImmutableGpxTrack;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.directdownload.DownloadDataGui;
import org.openstreetmap.josm.plugins.directdownload.GpxServerReader;
import org.openstreetmap.josm.plugins.directdownload.UserTrack;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

public class DirectDownload
extends Plugin {
    private DownloadAction openaction = new DownloadAction();

    public DirectDownload(PluginInformation info) {
        super(info);
        MainMenu.add((JMenu)MainApplication.getMenu().gpsMenu, (JosmAction)this.openaction);
    }

    static class DownloadAction
    extends JosmAction {
        DownloadAction() {
            super(I18n.tr((String)"Download Track ...", (Object[])new Object[0]), "DownloadAction", I18n.tr((String)"Download GPX track from openstreetmap.org", (Object[])new Object[0]), null, false);
        }

        public void actionPerformed(ActionEvent event) {
            DownloadDataGui go = new DownloadDataGui();
            go.setVisible(true);
            ArrayList<UserTrack> tracks = go.getSelectedUserTracks();
            if (go.getValue() != 1 || tracks == null) {
                return;
            }
            for (UserTrack track : tracks) {
                GpxData data = new GpxServerReader().loadGpx(Long.parseLong(track.id));
                if (data == null) {
                    return;
                }
                GpxData dataNew = new GpxData();
                for (GpxTrack trk : data.getTracks()) {
                    HashMap<String, String> attrib = new HashMap<String, String>(trk.getAttributes());
                    if (!trk.getAttributes().containsKey("name")) {
                        attrib.put("name", track.filename);
                    }
                    if (!trk.getAttributes().containsKey("desc")) {
                        attrib.put("desc", track.description);
                    }
                    dataNew.addTrack((GpxTrack)new ImmutableGpxTrack(new ArrayList(trk.getSegments()), attrib));
                }
                data = dataNew;
                GpxLayer gpxLayer = new GpxLayer(data, (String.valueOf(track.filename) + " " + track.description).trim());
                if (data.hasRoutePoints() || data.hasTrackPoints()) {
                    MainApplication.getLayerManager().addLayer((Layer)gpxLayer);
                }
                if (!Config.getPref().getBoolean("marker.makeautomarkers", true) || data.waypoints.isEmpty()) continue;
                MarkerLayer ml = new MarkerLayer(data, I18n.tr((String)"Markers from {0}", (Object[])new Object[]{track.filename}), null, gpxLayer);
                if (ml.data.size() <= 0) continue;
                MainApplication.getLayerManager().addLayer((Layer)ml);
            }
        }
    }
}

