/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.plugins.commandline.CommandLine;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public abstract class AbstractOsmAction<T extends OsmPrimitive>
extends MapMode
implements AWTEventListener {
    private final CommandLine parentPlugin;
    private final Cursor cursorNormal;
    private final Cursor cursorActive;
    private Cursor currentCursor;
    private Point mousePos;
    private T nearestPrimitive;
    private boolean isCtrlDown;

    protected AbstractOsmAction(CommandLine parentPlugin, String activeCursorIcon) {
        super(null, "addsegment.png", null, ImageProvider.getCursor((String)"normal", (String)"selection"));
        this.parentPlugin = parentPlugin;
        this.cursorNormal = ImageProvider.getCursor((String)"normal", (String)"selection");
        this.cursorActive = ImageProvider.getCursor((String)"normal", (String)activeCursorIcon);
        this.currentCursor = this.cursorNormal;
        this.nearestPrimitive = null;
    }

    public void enterMode() {
        super.enterMode();
        this.currentCursor = this.cursorNormal;
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException ex) {
            Logging.warn((Throwable)ex);
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!MainApplication.getMap().mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        this.updCursor();
        MainApplication.getMap().mapView.repaint();
        super.mouseMoved(e);
    }

    public void mousePressed(MouseEvent e) {
        MapFrame map = MainApplication.getMap();
        if (!map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.processMouseEvent(e);
        if (this.nearestPrimitive != null) {
            DataSet ds = MainApplication.getLayerManager().getEditDataSet();
            if (this.isCtrlDown) {
                ds.clearSelection(new PrimitiveId[]{this.nearestPrimitive});
                map.mapView.repaint();
            } else {
                int maxInstances = this.parentPlugin.currentCommand.parameters.get((int)this.parentPlugin.currentCommand.currentParameterNum).maxInstances;
                switch (maxInstances) {
                    case 0: {
                        ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                        map.mapView.repaint();
                        break;
                    }
                    case 1: {
                        ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                        map.mapView.repaint();
                        this.parentPlugin.loadParameter(this.nearestPrimitive, true);
                        break;
                    }
                    default: {
                        if (ds.getSelected().size() < maxInstances) {
                            ds.addSelected(new PrimitiveId[]{this.nearestPrimitive});
                            map.mapView.repaint();
                            break;
                        }
                        this.parentPlugin.printHistory("Maximum instances is " + maxInstances);
                    }
                }
            }
        }
        super.mousePressed(e);
    }

    @Override
    public void eventDispatched(AWTEvent arg0) {
        if (!(arg0 instanceof KeyEvent)) {
            return;
        }
        KeyEvent ev = (KeyEvent)arg0;
        boolean bl = this.isCtrlDown = (ev.getModifiersEx() & 0x80) != 0;
        if (ev.getKeyCode() == 27 && ev.getID() == 401) {
            ev.consume();
            this.cancelDrawing();
        }
    }

    private void updCursor() {
        if (this.mousePos != null) {
            if (!MainApplication.isDisplayingMapView()) {
                return;
            }
            this.nearestPrimitive = this.getNearest(this.mousePos);
            if (this.nearestPrimitive != null) {
                this.setCursor(this.cursorActive);
            } else {
                this.setCursor(this.cursorNormal);
            }
        }
    }

    protected abstract T getNearest(Point var1);

    private void processMouseEvent(MouseEvent e) {
        if (e != null) {
            this.mousePos = e.getPoint();
        }
    }

    private void setCursor(Cursor c) {
        if (this.currentCursor.equals(c)) {
            return;
        }
        try {
            EventQueue.invokeLater(() -> {
                if (!this.getClass().isAssignableFrom(MainApplication.getMap().mapMode.getClass())) {
                    return;
                }
                MainApplication.getMap().mapView.setCursor(c);
            });
            this.currentCursor = c;
        }
        catch (Exception e) {
            Logging.warn((Throwable)e);
        }
    }

    public void cancelDrawing() {
        MapFrame map = MainApplication.getMap();
        if (map == null || map.mapView == null) {
            return;
        }
        map.statusLine.setHeading(-1.0);
        map.statusLine.setAngle(-1.0);
        map.mapView.repaint();
        this.updateStatusLine();
        this.parentPlugin.abortInput();
    }
}

