/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.elevation.HgtReader;
import org.openstreetmap.josm.plugins.elevation.UnitMode;
import org.openstreetmap.josm.plugins.elevation.gpx.GeoidCorrectionKind;

public final class ElevationHelper {
    public static double METER_TO_FEET = 3.280948;
    private static String[] IMPERIAL_SYSTEM_COUNTRIES = new String[]{"en_US", "en_CA", "en_AU", "en_NZ", "en_ZA"};
    public static double NO_ELEVATION = Double.NaN;
    public static final String HEIGHT_ATTRIBUTE = "ele";
    private static UnitMode unitMode = UnitMode.NotSelected;
    private static GeoidCorrectionKind geoidKind = GeoidCorrectionKind.None;
    private static HgtReader hgt = new HgtReader();

    private ElevationHelper() {
    }

    public static GeoidCorrectionKind getGeoidKind() {
        return geoidKind;
    }

    public static void setGeoidKind(GeoidCorrectionKind geoidKind) {
        ElevationHelper.geoidKind = geoidKind;
    }

    public static UnitMode getUnitMode() {
        if (unitMode != UnitMode.NotSelected) {
            return unitMode;
        }
        unitMode = UnitMode.Metric;
        Locale l = Locale.getDefault();
        for (int i = 0; i < IMPERIAL_SYSTEM_COUNTRIES.length; ++i) {
            String ctry = l.toString();
            if (!IMPERIAL_SYSTEM_COUNTRIES[i].equals(ctry)) continue;
            unitMode = UnitMode.Imperial;
        }
        return unitMode;
    }

    public static String getUnit() {
        switch (ElevationHelper.getUnitMode()) {
            case Metric: {
                return "m";
            }
            case Imperial: {
                return "ft";
            }
        }
        throw new RuntimeException("Invalid or unsupported unit mode: " + (Object)((Object)unitMode));
    }

    public static boolean isValidElevation(double ele) {
        return !Double.isNaN(ele);
    }

    public static double getElevation(WayPoint wpt) {
        if (wpt == null) {
            return NO_ELEVATION;
        }
        double eleInt = ElevationHelper.getSrtmElevation(wpt.getCoor());
        if (ElevationHelper.isValidElevation(eleInt)) {
            return ElevationHelper.convert(eleInt);
        }
        if (!wpt.attr.containsKey(HEIGHT_ATTRIBUTE)) {
            return NO_ELEVATION;
        }
        String height = wpt.getString(HEIGHT_ATTRIBUTE);
        try {
            double z = Double.parseDouble(height);
            return ElevationHelper.convert(z);
        }
        catch (NumberFormatException e) {
            System.err.println(String.format("Cannot parse double from '%s': %s", height, e.getMessage()));
            return NO_ELEVATION;
        }
    }

    private static double getElevation(LatLon ll) {
        double ele = ElevationHelper.getSrtmElevation(ll);
        return ElevationHelper.convert(ele);
    }

    private static double convert(double ele) {
        if (ElevationHelper.isValidElevation(ele)) {
            if (ElevationHelper.getUnitMode() == UnitMode.Imperial) {
                return ElevationHelper.meter2Feet(ele);
            }
            return ele;
        }
        return NO_ELEVATION;
    }

    public static double computeSlope(LatLon w1, LatLon w2) {
        if (w1.equals((Object)w2)) {
            return 0.0;
        }
        double distInMeter = ElevationHelper.convert(w1.greatCircleDistance(w2) / 100.0);
        int ele1 = (int)ElevationHelper.getElevation(w1);
        int ele2 = (int)ElevationHelper.getElevation(w2);
        int dH = ele2 - ele1;
        return (double)dH / distInMeter;
    }

    public static double meter2Feet(double meter) {
        return meter * METER_TO_FEET;
    }

    public static String getElevationText(int elevation) {
        return String.format("%d %s", elevation, ElevationHelper.getUnit());
    }

    public static String getElevationText(double elevation) {
        return String.format("%d %s", (int)Math.round(elevation), ElevationHelper.getUnit());
    }

    public static String getElevationText(WayPoint wpt) {
        if (wpt == null) {
            return "-";
        }
        int elevation = (int)Math.round(ElevationHelper.getElevation(wpt));
        return String.format("%d %s", elevation, ElevationHelper.getUnit());
    }

    public static String getTimeText(WayPoint wpt) {
        if (wpt == null) {
            return null;
        }
        int hour = ElevationHelper.getHourOfWayPoint(wpt);
        int min = ElevationHelper.getMinuteOfWayPoint(wpt);
        return String.format("%02d:%02d", hour, min);
    }

    public static double getSrtmElevation(LatLon ll) {
        double eleHgt;
        if (ll != null && ElevationHelper.isValidElevation(eleHgt = hgt.getElevationFromHgt(ll))) {
            return eleHgt;
        }
        return NO_ELEVATION;
    }

    public static boolean hasSrtmData(Bounds bounds) {
        if (bounds == null) {
            return false;
        }
        LatLon tl = bounds.getMin();
        LatLon br = bounds.getMax();
        return ElevationHelper.isValidElevation(ElevationHelper.getSrtmElevation(tl)) && ElevationHelper.isValidElevation(ElevationHelper.getSrtmElevation(br));
    }

    public static byte getGeoidCorrection(WayPoint wpt) {
        return 0;
    }

    public static List<WayPoint> downsampleWayPoints(List<WayPoint> origList, int targetSize) {
        if (origList == null) {
            return null;
        }
        if (targetSize <= 0) {
            throw new IllegalArgumentException("targetSize must be greater than zero");
        }
        int origSize = origList.size();
        if (origSize <= targetSize) {
            return origList;
        }
        int delta = (int)Math.max(Math.ceil(origSize / targetSize), 2.0);
        ArrayList<WayPoint> res = new ArrayList<WayPoint>(targetSize);
        for (int i = 0; i < origSize; i += delta) {
            res.add(origList.get(i));
        }
        return res;
    }

    public static int getHourOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(wpt.getDate());
        return calendar.get(11);
    }

    public static int getMinuteOfWayPoint(WayPoint wpt) {
        if (wpt == null) {
            return -1;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(wpt.getDate());
        return calendar.get(12);
    }
}

