/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.customizepublictransportstop;

import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.customizepublictransportstop.StopArea;
import org.openstreetmap.josm.plugins.customizepublictransportstop.StopAreaOperationBase;

public class CreateStopAreaFromSelectedObjectOperation
extends StopAreaOperationBase {
    public CreateStopAreaFromSelectedObjectOperation(DataSet currentDataSet) {
        super(currentDataSet);
    }

    public void parseTags(StopArea stopArea, OsmPrimitive member) {
        if (stopArea.name == null) {
            stopArea.name = CreateStopAreaFromSelectedObjectOperation.getTagValue(member, "name");
        }
        if (stopArea.nameEn == null) {
            stopArea.nameEn = CreateStopAreaFromSelectedObjectOperation.getTagValue(member, "name:en");
        }
        if (stopArea.operator == null) {
            stopArea.operator = CreateStopAreaFromSelectedObjectOperation.getTagValue(member, "operator");
        }
        if (stopArea.network == null) {
            stopArea.network = CreateStopAreaFromSelectedObjectOperation.getTagValue(member, "network");
        }
        if (stopArea.service == null) {
            stopArea.service = CreateStopAreaFromSelectedObjectOperation.getTagValue(member, "service");
        }
        if ("local".equals(stopArea.service)) {
            stopArea.service = "commuter";
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "bus", "yes").booleanValue()) {
            stopArea.isBus = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "trolleybus", "yes").booleanValue()) {
            stopArea.isTrolleybus = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "share_taxi", "yes").booleanValue()) {
            stopArea.isShareTaxi = true;
        }
        if (!stopArea.isBus.booleanValue() && !stopArea.isShareTaxi.booleanValue() && !stopArea.isTrolleybus.booleanValue() && CreateStopAreaFromSelectedObjectOperation.compareTag(member, "highway", "bus_stop").booleanValue()) {
            stopArea.isBus = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "tram", "yes").booleanValue() || CreateStopAreaFromSelectedObjectOperation.compareTag(member, "railway", "tram_stop").booleanValue()) {
            stopArea.isTram = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "railway", "halt").booleanValue()) {
            stopArea.isTrainStop = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "railway", "station").booleanValue()) {
            stopArea.isTrainStation = true;
        }
        if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "amenity", "bus_station").booleanValue()) {
            stopArea.isBusStation = true;
        }
        if (member == stopArea.selectedObject) {
            if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "bench", "yes").booleanValue()) {
                stopArea.isBench = true;
            }
            if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "shelter", "yes").booleanValue()) {
                stopArea.isShelter = true;
            }
            if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "covered", "yes").booleanValue()) {
                stopArea.isCovered = true;
            }
            if (CreateStopAreaFromSelectedObjectOperation.compareTag(member, "area", "yes").booleanValue()) {
                stopArea.isArea = true;
            }
        }
    }

    public boolean testIsTransportTypeAssigned(OsmPrimitive platform) {
        String[] transportTypes;
        for (String transportType : transportTypes = new String[]{"bus", "trolleybus", "share_taxi", "tram", "train"}) {
            if (!CreateStopAreaFromSelectedObjectOperation.compareTag(platform, transportType, "yes").booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void fromSelectedObject(StopArea stopArea) {
        ArrayList<OsmPrimitive> selectedObjects = new ArrayList<OsmPrimitive>();
        selectedObjects.add(stopArea.selectedObject);
        for (Relation rel : OsmPrimitive.getParentRelations(selectedObjects)) {
            if (CreateStopAreaFromSelectedObjectOperation.compareTag((OsmPrimitive)rel, "type", "public_transport").booleanValue() && CreateStopAreaFromSelectedObjectOperation.compareTag((OsmPrimitive)rel, "public_transport", "stop_area").booleanValue()) {
                stopArea.stopAreaRelation = rel;
            }
            if (stopArea.stopAreaRelation == null) continue;
            break;
        }
        if (stopArea.stopAreaRelation != null) {
            this.parseTags(stopArea, (OsmPrimitive)stopArea.stopAreaRelation);
            this.parseTags(stopArea, stopArea.selectedObject);
            for (RelationMember member : stopArea.stopAreaRelation.getMembers()) {
                if (member.getMember() instanceof Node && CreateStopAreaFromSelectedObjectOperation.compareTag(member.getMember(), "public_transport", "stop_position").booleanValue()) {
                    stopArea.isStopPointExists = true;
                    stopArea.stopPoints.add(member.getNode());
                } else if (CreateStopAreaFromSelectedObjectOperation.compareTag(member.getMember(), "public_transport", "platform").booleanValue()) {
                    stopArea.platforms.add(member.getMember());
                } else {
                    stopArea.otherMembers.add(member.getMember());
                }
                this.parseTags(stopArea, member.getMember());
            }
            if (!stopArea.platforms.contains(stopArea.selectedObject)) {
                this.parseTags(stopArea, stopArea.selectedObject);
                stopArea.platforms.add(stopArea.selectedObject);
            }
        } else {
            this.parseTags(stopArea, stopArea.selectedObject);
            stopArea.platforms.add(stopArea.selectedObject);
        }
        for (OsmPrimitive platform : stopArea.platforms) {
            if (!this.testIsTransportTypeAssigned(platform)) continue;
            stopArea.isAssignTransportType = true;
            break;
        }
        if (!(stopArea.isBus.booleanValue() || stopArea.isTrolleybus.booleanValue() || stopArea.isShareTaxi.booleanValue() || stopArea.selectedObject == null || !CreateStopAreaFromSelectedObjectOperation.compareTag(stopArea.selectedObject, "highway", "bus_stop").booleanValue() && !stopArea.isBusStation.booleanValue())) {
            stopArea.isBus = true;
        }
    }

    @Override
    public StopArea performCustomizing(StopArea stopArea) {
        if (this.getCurrentDataSet() == null) {
            return null;
        }
        Collection selectedObjects = this.getCurrentDataSet().getSelectedNodesAndWays();
        if (null == selectedObjects || selectedObjects.isEmpty()) {
            return null;
        }
        OsmPrimitive selectedObject = (OsmPrimitive)selectedObjects.iterator().next();
        if (selectedObject == null) {
            return null;
        }
        if (stopArea == null) {
            stopArea = new StopArea(selectedObject);
        }
        this.fromSelectedObject(stopArea);
        return stopArea;
    }
}

