/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import java.util.Vector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.models.TrackStoplistTableModel;
import org.openstreetmap.josm.tools.I18n;

public class TrackStoplistDeleteCommand
extends Command {
    private Vector<Integer> workingLines = null;
    private Vector<NodeTimeName> nodesForUndo = null;
    private TrackStoplistTableModel stoplistTM = null;

    public TrackStoplistDeleteCommand(StopImporterAction controller) {
        super(MainApplication.getLayerManager().getEditDataSet());
        this.stoplistTM = controller.getCurrentTrack().stoplistTM;
        this.workingLines = new Vector();
        this.nodesForUndo = new Vector();
        int[] selectedLines = controller.getDialog().getStoplistTable().getSelectedRows();
        if (selectedLines.length > 0) {
            int i = 0;
            while (i < selectedLines.length) {
                this.workingLines.add(selectedLines[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.stoplistTM.getRowCount()) {
                this.workingLines.add(i);
                ++i;
            }
        }
    }

    public boolean executeCommand() {
        this.nodesForUndo.clear();
        int i = this.workingLines.size() - 1;
        while (i >= 0) {
            int j = this.workingLines.elementAt(i);
            Node node = this.stoplistTM.nodeAt(j);
            this.nodesForUndo.add(new NodeTimeName(node, (String)this.stoplistTM.getValueAt(j, 0), (String)this.stoplistTM.getValueAt(j, 1), (TransText)this.stoplistTM.getValueAt(j, 2)));
            this.stoplistTM.removeRow(j);
            if (node != null) {
                MainApplication.getLayerManager().getEditDataSet().removePrimitive((PrimitiveId)node);
                node.setDeleted(true);
            }
            --i;
        }
        return true;
    }

    public void undoCommand() {
        int i = 0;
        while (i < this.workingLines.size()) {
            int j = this.workingLines.elementAt(i);
            NodeTimeName ntn = this.nodesForUndo.elementAt(this.workingLines.size() - i - 1);
            this.stoplistTM.insertRow(j, ntn.node, ntn.time, ntn.name, ntn.shelter);
            if (ntn.node != null) {
                ntn.node.setDeleted(false);
                MainApplication.getLayerManager().getEditDataSet().addPrimitive((OsmPrimitive)ntn.node);
            }
            ++i;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Delete track stop", (Object[])new Object[0]);
    }

    private static class NodeTimeName {
        public Node node;
        public String time;
        public String name;
        public TransText shelter;

        NodeTimeName(Node node, String time, String name, TransText shelter) {
            this.node = node;
            this.time = time;
            this.name = name;
            this.shelter = shelter;
        }
    }
}

