/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.api;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public final class CadastreAPI {
    private static final String API_ENDPOINT = "https://sandbox.geo.api.gouv.fr/cadastre/";

    private CadastreAPI() {
    }

    public static Set<String> getSheets(Bounds bounds) throws IOException {
        return CadastreAPI.getSheets(bounds.getMinLon(), bounds.getMinLat(), bounds.getMaxLon(), bounds.getMaxLat());
    }

    public static Set<String> getSheets(double minlon, double minlat, double maxlon, double maxlat) throws IOException {
        URL url = new URL("https://sandbox.geo.api.gouv.fr/cadastre//feuilles?bbox=" + String.join((CharSequence)",", Double.toString(minlon), Double.toString(minlat), Double.toString(maxlon), Double.toString(maxlat)));
        try {
            JsonStructure json = Json.createReader((Reader)new StringReader(HttpClient.create((URL)url).connect().fetchContent())).read();
            if (json instanceof JsonArray) {
                return json.asJsonArray().stream().map(x -> x.asJsonObject().getString("id")).collect(Collectors.toSet());
            }
            JsonObject obj = json.asJsonObject();
            throw new IOException((Throwable)new OsmApiException(obj.getInt("code"), null, obj.getString("message"), url.toExternalForm()));
        }
        catch (MalformedURLException e) {
            throw new JosmRuntimeException((Throwable)e);
        }
    }
}

