/*
 * Decompiled with CFR 0.152.
 */
package relcontext;

import javax.swing.JLabel;
import org.openstreetmap.josm.data.osm.Relation;
import relcontext.ChosenRelation;
import relcontext.ChosenRelationListener;

public class ChosenRelationComponent
extends JLabel
implements ChosenRelationListener {
    private static final String[] TYPE_KEYS = new String[]{"natural", "landuse", "place", "waterway", "leisure", "amenity", "restriction", "public_transport", "route", "enforcement"};
    private static final String[] NAMING_TAGS = new String[]{"name", "place_name", "ref", "destination", "note"};

    public ChosenRelationComponent(ChosenRelation rel) {
        super("");
        rel.addChosenRelationListener(this);
    }

    @Override
    public void chosenRelationChanged(Relation oldRelation, Relation newRelation) {
        this.setText(this.prepareText(newRelation));
        this.repaint();
    }

    protected String prepareText(Relation rel) {
        if (rel == null) {
            return "";
        }
        String type = rel.get("type");
        if (type == null || type.length() == 0) {
            type = "-";
        }
        String tag = null;
        int i = 0;
        while (i < TYPE_KEYS.length && tag == null) {
            if (rel.hasKey(TYPE_KEYS[i])) {
                tag = TYPE_KEYS[i];
            }
            ++i;
        }
        if (tag != null) {
            tag = String.valueOf(tag.substring(0, 2)) + "=" + rel.get(tag);
        }
        String name = null;
        int i2 = 0;
        while (i2 < NAMING_TAGS.length && name == null) {
            if (rel.hasKey(NAMING_TAGS[i2])) {
                name = rel.get(NAMING_TAGS[i2]);
            }
            ++i2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(type.substring(0, 1));
        if (type.equals("boundary") && rel.hasKey("admin_level")) {
            sb.append(rel.get("admin_level"));
        }
        if (name != null) {
            sb.append(" \"").append(name).append('\"');
        }
        if (tag != null) {
            sb.append("; ").append(tag);
        }
        sb.append(" (").append(rel.getMembersCount()).append(')');
        return sb.toString();
    }
}

