/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.Channel;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.ChannelDiGraph;
import org.openstreetmap.josm.plugins.JunctionChecker.datastructure.LeadsTo;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.BackPropagation;
import org.openstreetmap.josm.plugins.JunctionChecker.junctionchecking.TRDFS;

public class JProcess {
    private ArrayList<Channel> vertices;
    private ChannelDiGraph digraph;
    private TRDFS trdfs;
    private BackPropagation backpropagation;
    private ArrayList<LeadsTo> cycleEdges;

    public JProcess(ArrayList<Channel> subgraph, ChannelDiGraph digraph) {
        this.digraph = digraph;
        this.vertices = subgraph;
        this.trdfs = new TRDFS(this.vertices, digraph);
        this.backpropagation = new BackPropagation(digraph);
    }

    public void jProcess(ArrayList<Channel> entries) {
        int i;
        ArrayList<Channel> nodes = this.digraph.getChannels();
        for (i = 0; i < nodes.size(); ++i) {
            nodes.get(i).setVisited(-1);
            nodes.get(i).ereaseReachableNodes();
        }
        for (i = 0; i < this.digraph.getLeadsTo().size(); ++i) {
            this.digraph.getLeadsTo().get(i).setForwardEdge(false);
        }
        this.trdfs.ereaseCycleEdges();
        for (i = 0; i < entries.size(); ++i) {
            if (entries.get(i).getVisited() != -1) continue;
            this.trdfs.trdfs(entries.get(i));
        }
        this.cycleEdges = this.trdfs.getCycleEdges();
        for (int j = 0; j < this.cycleEdges.size(); ++j) {
            this.backpropagation.backPropagation(this.cycleEdges.get(j).getFromChannel(), this.cycleEdges.get(j).getToChannel(), this.cycleEdges.get(j).getToChannel());
        }
    }
}

