/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSource;
import org.openstreetmap.josm.plugins.graphview.core.data.DataSourceObserver;
import org.openstreetmap.josm.plugins.graphview.core.data.MapBasedTagGroup;
import org.openstreetmap.josm.plugins.graphview.core.data.TagGroup;

public class JOSMDataSource
implements DataSource<Node, Way, Relation, RelationMember> {
    private static final TagGroup EMPTY_TAG_GROUP;
    private final Set<DataSourceObserver> observers = new HashSet<DataSourceObserver>();

    static {
        HashMap<String, String> emptyMap = new HashMap<String, String>(0);
        EMPTY_TAG_GROUP = new MapBasedTagGroup(emptyMap);
    }

    @Override
    public double getLat(Node node) {
        return node.getCoor().lat();
    }

    @Override
    public double getLon(Node node) {
        return node.getCoor().lon();
    }

    @Override
    public Iterable<RelationMember> getMembers(Relation relation) {
        return relation.getMembers();
    }

    @Override
    public Iterable<Node> getNodes(Way way) {
        return new FilteredOsmPrimitiveIterable<Node>(way.getNodes());
    }

    @Override
    public Iterable<Node> getNodes() {
        return new FilteredOsmPrimitiveIterable<Node>(MainApplication.getLayerManager().getEditDataSet().getNodes());
    }

    @Override
    public Iterable<Relation> getRelations() {
        return new FilteredRelationIterable(MainApplication.getLayerManager().getEditDataSet().getRelations());
    }

    @Override
    public Iterable<Way> getWays() {
        return new FilteredOsmPrimitiveIterable<Way>(MainApplication.getLayerManager().getEditDataSet().getWays());
    }

    @Override
    public TagGroup getTagsN(Node node) {
        return this.getTags((OsmPrimitive)node);
    }

    @Override
    public TagGroup getTagsW(Way way) {
        return this.getTags((OsmPrimitive)way);
    }

    @Override
    public TagGroup getTagsR(Relation relation) {
        return this.getTags((OsmPrimitive)relation);
    }

    private TagGroup getTags(OsmPrimitive primitive) {
        if (primitive.getKeys() == null) {
            return EMPTY_TAG_GROUP;
        }
        return new MapBasedTagGroup((Map<String, String>)primitive.getKeys());
    }

    @Override
    public Object getMember(RelationMember member) {
        return member.getMember();
    }

    @Override
    public String getRole(RelationMember member) {
        return member.getRole();
    }

    @Override
    public boolean isNMember(RelationMember member) {
        return member.getMember() instanceof Node;
    }

    @Override
    public boolean isWMember(RelationMember member) {
        return member.getMember() instanceof Way;
    }

    @Override
    public boolean isRMember(RelationMember member) {
        return member.getMember() instanceof Relation;
    }

    @Override
    public void addObserver(DataSourceObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void deleteObserver(DataSourceObserver observer) {
        this.observers.remove(observer);
    }

    public static class FilteredOsmPrimitiveIterable<P extends OsmPrimitive>
    implements Iterable<P> {
        private final Iterable<P> originalIterable;

        public FilteredOsmPrimitiveIterable(Iterable<P> originalIterable) {
            this.originalIterable = originalIterable;
        }

        @Override
        public Iterator<P> iterator() {
            return new FilteredIterator(this.originalIterable.iterator());
        }

        protected boolean accept(P primitive) {
            return !primitive.isDeleted() && !primitive.isIncomplete();
        }

        private class FilteredIterator
        implements Iterator<P> {
            private final Iterator<P> originalIterator;
            private P next;

            FilteredIterator(Iterator<P> originalIterator) {
                this.originalIterator = originalIterator;
                this.updateNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public P next() {
                if (this.next != null) {
                    Object result = this.next;
                    this.updateNext();
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void updateNext() {
                this.next = null;
                while (this.originalIterator.hasNext()) {
                    OsmPrimitive originalNext = (OsmPrimitive)this.originalIterator.next();
                    if (!FilteredOsmPrimitiveIterable.this.accept(originalNext)) continue;
                    this.next = originalNext;
                    break;
                }
            }
        }
    }

    public static class FilteredRelationIterable
    extends FilteredOsmPrimitiveIterable<Relation> {
        public FilteredRelationIterable(Iterable<Relation> originalIterable) {
            super(originalIterable);
        }

        @Override
        protected boolean accept(Relation relation) {
            boolean complete = true;
            for (RelationMember member : relation.getMembers()) {
                if (member.getMember() != null && !member.getMember().isDeleted() && !member.getMember().isIncomplete()) continue;
                complete = false;
            }
            return complete && super.accept(relation);
        }
    }

    static class RelationMemberImpl {
        private final String role;
        private final Object member;

        RelationMemberImpl(RelationMember originalMember) {
            this.role = originalMember.getRole();
            this.member = originalMember.getMember();
        }

        public String getRole() {
            return this.role;
        }

        public Object getMember() {
            return this.member;
        }
    }
}

