/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.alignways.geometry;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openstreetmap.josm.plugins.alignways.geometry.AlignWaysGeomLine;

public class AlignWaysGeomLineTest {
    private AlignWaysGeomLine line_x1y1x2y2;
    private AlignWaysGeomLine line_par_x1y1x2y2;
    private AlignWaysGeomLine line_abc;
    private AlignWaysGeomLine line_mb;
    private AlignWaysGeomLine line_line;
    private AlignWaysGeomLine line_horiz;
    private AlignWaysGeomLine line_vert;

    @Before
    public void setUp() {
        this.line_x1y1x2y2 = new AlignWaysGeomLine(-2.0, -1.0, 4.0, 3.0);
        this.line_abc = new AlignWaysGeomLine(0.6666666666666666, -1.0, 0.3333333333333333);
        this.line_mb = new AlignWaysGeomLine(0.6666666666666666, 0.3333333333333333);
        this.line_line = new AlignWaysGeomLine(this.line_x1y1x2y2);
        this.line_par_x1y1x2y2 = new AlignWaysGeomLine(-2.0, -2.0, 4.0, 2.0);
        this.line_horiz = new AlignWaysGeomLine(-5.0, 3.0, 6.0, 3.0);
        this.line_vert = new AlignWaysGeomLine(2.0, -3.0, 2.0, -10.5);
    }

    @Test
    public void LineLineEquiv() {
        Assert.assertTrue((boolean)this.line_x1y1x2y2.equals(this.line_line));
    }

    @Test
    public void LineAbcLineEquiv() {
        Assert.assertTrue((boolean)this.line_x1y1x2y2.equals(this.line_abc));
    }

    @Test
    public void LineMbLineEquiv() {
        Assert.assertTrue((boolean)this.line_x1y1x2y2.equals(this.line_mb));
    }

    @Test
    public void LineAbcMbEquiv() {
        Assert.assertTrue((boolean)this.line_abc.equals(this.line_mb));
    }

    @Test
    public void LineLineParallel() {
        this.line_x1y1x2y2.getIntersection(this.line_par_x1y1x2y2);
        Assert.assertTrue((this.line_x1y1x2y2.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_PARALLEL ? 1 : 0) != 0);
    }

    @Test
    public void LineAbcOverlap() {
        this.line_x1y1x2y2.getIntersection(this.line_abc);
        Assert.assertTrue((this.line_x1y1x2y2.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_OVERLAP ? 1 : 0) != 0);
    }

    @Test
    public void LineMbOverlap() {
        this.line_x1y1x2y2.getIntersection(this.line_mb);
        Assert.assertTrue((this.line_x1y1x2y2.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_OVERLAP ? 1 : 0) != 0);
    }

    @Test
    public void AbcMbOverlap() {
        this.line_abc.getIntersection(this.line_mb);
        Assert.assertTrue((this.line_abc.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.LINES_OVERLAP ? 1 : 0) != 0);
    }

    @Test
    public void GetXOnHoriz() {
        Assert.assertTrue((boolean)this.line_horiz.getXonLine(2.0).isNaN());
    }

    @Test
    public void GetYOnVert() {
        Assert.assertTrue((boolean)this.line_vert.getYonLine(2.0).isNaN());
    }

    @Test
    public void StatusUndefAfterConstruct() throws Exception {
        AlignWaysGeomLine newLine = new AlignWaysGeomLine(1.0, 2.0);
        Assert.assertTrue((newLine.getIntersectionStatus() == AlignWaysGeomLine.IntersectionStatus.UNDEFINED ? 1 : 0) != 0);
    }
}

