/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class FixUnresolvedStreetsAction
extends JosmAction
implements DataSelectionListener {
    private AddressEditContainer addressEditContainer;
    private Collection<? extends OsmPrimitive> newSelection;

    public FixUnresolvedStreetsAction() {
        super(I18n.tr((String)"Fix street addresses", (Object[])new Object[0]), "fixstreets_24", I18n.tr((String)"Find and fix addresses without (valid) streets.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:AddressEdit", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Address Edit", (Object[])new Object[0])}), (int)88, (int)5009), false);
        this.setEnabled(false);
        this.addressEditContainer = new AddressEditContainer();
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        this.newSelection = event.getSelection();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.addressEditContainer != null) {
            this.addressEditContainer.attachToDataSet(this.newSelection);
            try {
                AddressEditDialog dlg = new AddressEditDialog(this.addressEditContainer);
                dlg.setVisible(true);
            }
            finally {
                this.addressEditContainer.detachFromDataSet();
            }
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditDataSet() != null);
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty() || this.getLayerManager().getEditDataSet() != null);
    }

    private void generateTagCode(AddressEditContainer addrVisitor) {
        for (String tag : addrVisitor.getTags()) {
            String methodName = this.createMethodName(tag);
            System.out.println(String.format("/** Check if OSM primitive has a tag '%s'.\n * @param osmPrimitive The OSM entity to check.*/\npublic static boolean has%sTag(OsmPrimitive osmPrimitive) {\n return osmPrimitive != null ? osmPrimitive.hasKey(%s_TAG) : false;\n}\n", tag, methodName, tag.toUpperCase().replaceAll(":", "_")));
            System.out.println(String.format("/** Gets the value of tag '%s'.\n * @param osmPrimitive The OSM entity to check.*/\npublic static String get%sValue(OsmPrimitive osmPrimitive) {\n return osmPrimitive != null ? osmPrimitive.get(%s_TAG) : null;\n}\n", tag, methodName, tag.toUpperCase().replaceAll(":", "_")));
        }
        for (String tag : addrVisitor.getTags()) {
            System.out.println(String.format("public static final String %s_TAG = \"%s\";", tag.toUpperCase().replaceAll(":", "_"), tag));
        }
        for (String value : addrVisitor.getValues().keySet()) {
            String tag = addrVisitor.getValues().get(value);
            String tags = tag.toUpperCase().replaceAll(":", "_");
            String values = value.toUpperCase().replaceAll(":", "_");
            System.out.println(String.format("public static final String %s_%s_VALUE = \"%s\";", tags, values, value));
        }
    }

    private String createMethodName(String osmName) {
        StringBuffer result = new StringBuffer(osmName.length());
        boolean nextUp = false;
        int i = 0;
        while (i < osmName.length()) {
            char c = osmName.charAt(i);
            if (i == 0) {
                result.append(Character.toUpperCase(c));
            } else if (c == '_' || c == ':') {
                nextUp = true;
            } else if (nextUp) {
                result.append(Character.toUpperCase(c));
                nextUp = false;
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

