/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fixAddresses.gui.actions;

import org.openstreetmap.josm.plugins.fixAddresses.AddressEditContainer;
import org.openstreetmap.josm.plugins.fixAddresses.OSMAddress;
import org.openstreetmap.josm.plugins.fixAddresses.OSMStreet;
import org.openstreetmap.josm.plugins.fixAddresses.gui.AddressEditSelectionEvent;
import org.openstreetmap.josm.plugins.fixAddresses.gui.actions.AbstractAddressEditAction;
import org.openstreetmap.josm.tools.I18n;

public class AssignAddressToStreetAction
extends AbstractAddressEditAction {
    private static final long serialVersionUID = -6180491357232121384L;

    public AssignAddressToStreetAction() {
        super(I18n.tr((String)"Assign address to street", (Object[])new Object[0]), "assignstreet_24", I18n.tr((String)"Assign the selected address(es) to the selected street.", (Object[])new Object[0]), "fixaddresses/assignaddresstostreet");
    }

    @Override
    public void addressEditActionPerformed(AddressEditSelectionEvent ev) {
        OSMStreet streetNode = ev.getSelectedStreet();
        if (streetNode != null && ev.getSelectedUnresolvedAddresses() != null) {
            this.beginTransaction(String.valueOf(I18n.tr((String)"Set street name", (Object[])new Object[0])) + " '" + streetNode.getName() + "'");
            for (OSMAddress addrNode : ev.getSelectedUnresolvedAddresses()) {
                this.beginObjectTransaction(addrNode);
                addrNode.assignStreet(streetNode);
                this.finishObjectTransaction(addrNode);
            }
            this.finishTransaction();
        }
    }

    @Override
    public void updateEnabledState(AddressEditSelectionEvent ev) {
        this.setEnabled(ev.getSelectedStreet() != null && ev.hasUnresolvedAddresses());
    }

    @Override
    public void updateEnabledState(AddressEditContainer container) {
        this.setEnabled(false);
    }

    @Override
    public void addressEditActionPerformed(AddressEditContainer container) {
    }
}

