/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input.buffer;

import java.util.Objects;

public class CircularByteBuffer {
    private final byte[] buffer;
    private int startOffset;
    private int endOffset;
    private int currentNumberOfBytes;

    public CircularByteBuffer(int pSize) {
        this.buffer = new byte[pSize];
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }

    public CircularByteBuffer() {
        this(8192);
    }

    public byte read() {
        if (this.currentNumberOfBytes <= 0) {
            throw new IllegalStateException("No bytes available.");
        }
        byte b = this.buffer[this.startOffset];
        --this.currentNumberOfBytes;
        if (++this.startOffset == this.buffer.length) {
            this.startOffset = 0;
        }
        return b;
    }

    public void read(byte[] pBuffer, int pOffset, int pLength) {
        Objects.requireNonNull(pBuffer);
        if (pOffset < 0 || pOffset >= pBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + pOffset);
        }
        if (pLength < 0 || pLength > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + pLength);
        }
        if (pOffset + pLength > pBuffer.length) {
            throw new IllegalArgumentException("The supplied byte array contains only " + pBuffer.length + " bytes, but offset, and length would require " + (pOffset + pLength - 1));
        }
        if (this.currentNumberOfBytes < pLength) {
            throw new IllegalStateException("Currently, there are only " + this.currentNumberOfBytes + "in the buffer, not " + pLength);
        }
        int offset = pOffset;
        for (int i = 0; i < pLength; ++i) {
            pBuffer[offset++] = this.buffer[this.startOffset];
            --this.currentNumberOfBytes;
            if (++this.startOffset != this.buffer.length) continue;
            this.startOffset = 0;
        }
    }

    public void add(byte pByte) {
        if (this.currentNumberOfBytes >= this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        this.buffer[this.endOffset] = pByte;
        ++this.currentNumberOfBytes;
        if (++this.endOffset == this.buffer.length) {
            this.endOffset = 0;
        }
    }

    public boolean peek(byte[] pBuffer, int pOffset, int pLength) {
        Objects.requireNonNull(pBuffer, "Buffer");
        if (pOffset < 0 || pOffset >= pBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + pOffset);
        }
        if (pLength < 0 || pLength > this.buffer.length) {
            throw new IllegalArgumentException("Invalid length: " + pLength);
        }
        if (pLength < this.currentNumberOfBytes) {
            return false;
        }
        int offset = this.startOffset;
        for (int i = 0; i < pLength; ++i) {
            if (this.buffer[offset] != pBuffer[i + pOffset]) {
                return false;
            }
            if (++offset != this.buffer.length) continue;
            offset = 0;
        }
        return true;
    }

    public void add(byte[] pBuffer, int pOffset, int pLength) {
        Objects.requireNonNull(pBuffer, "Buffer");
        if (pOffset < 0 || pOffset >= pBuffer.length) {
            throw new IllegalArgumentException("Invalid offset: " + pOffset);
        }
        if (pLength < 0) {
            throw new IllegalArgumentException("Invalid length: " + pLength);
        }
        if (this.currentNumberOfBytes + pLength > this.buffer.length) {
            throw new IllegalStateException("No space available");
        }
        for (int i = 0; i < pLength; ++i) {
            this.buffer[this.endOffset] = pBuffer[pOffset + i];
            if (++this.endOffset != this.buffer.length) continue;
            this.endOffset = 0;
        }
        this.currentNumberOfBytes += pLength;
    }

    public boolean hasSpace() {
        return this.currentNumberOfBytes < this.buffer.length;
    }

    public boolean hasSpace(int pBytes) {
        return this.currentNumberOfBytes + pBytes <= this.buffer.length;
    }

    public boolean hasBytes() {
        return this.currentNumberOfBytes > 0;
    }

    public int getSpace() {
        return this.buffer.length - this.currentNumberOfBytes;
    }

    public int getCurrentNumberOfBytes() {
        return this.currentNumberOfBytes;
    }

    public void clear() {
        this.startOffset = 0;
        this.endOffset = 0;
        this.currentNumberOfBytes = 0;
    }
}

