/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.plugins.commandline.Command;
import org.openstreetmap.josm.plugins.commandline.Parameter;
import org.openstreetmap.josm.plugins.commandline.Relay;
import org.openstreetmap.josm.plugins.commandline.Type;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Loader
extends DefaultHandler {
    private final File dirToScan;
    private String currentFile;
    private String currentTag;
    private Command currentCommand;
    private Parameter currentParameter;
    private final ArrayList<Command> loadingCommands;

    public Loader(File dir) {
        this.dirToScan = dir;
        this.currentTag = "";
        this.loadingCommands = new ArrayList();
    }

    public ArrayList<Command> load() {
        try {
            SAXParser sp = SAXParserFactory.newInstance().newSAXParser();
            String[] list = this.dirToScan.list();
            if (list != null) {
                int i = 0;
                while (i < list.length) {
                    if (list[i].endsWith(".xml")) {
                        this.currentFile = String.valueOf(this.dirToScan.getPath()) + "/" + list[i];
                        this.loadFile(sp, this.currentFile);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
        return this.loadingCommands;
    }

    private void loadFile(SAXParser parser, String fileName) {
        try {
            String a = new File(fileName).toURI().toString().replace("file:/", "file:///");
            Logging.info((String)a);
            parser.parse(a, (DefaultHandler)this);
        }
        catch (Exception e) {
            Logging.error((Throwable)e);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) {
        block45: {
            int len;
            block44: {
                len = attrs.getLength();
                this.currentTag = rawName;
                if (!rawName.equals("command")) break block44;
                this.currentCommand = new Command();
                int i = 0;
                while (i < len) {
                    String Name = attrs.getQName(i);
                    String Value = attrs.getValue(i);
                    if (Name.equals("name")) {
                        this.currentCommand.name = Value;
                    } else if (Name.equals("run")) {
                        this.currentCommand.run = Value;
                    } else if (Name.equals("tracks")) {
                        if (Value.equals("bbox")) {
                            this.currentCommand.tracks = true;
                        }
                    } else if (Name.equals("icon")) {
                        this.currentCommand.icon = Value;
                    } else if (Name.equals("asynchronous")) {
                        this.currentCommand.asynchronous = Value.equals("true");
                    }
                    ++i;
                }
                break block45;
            }
            if (!rawName.equals("parameter")) break block45;
            this.currentParameter = new Parameter();
            int i = 0;
            while (i < len) {
                String Name = attrs.getQName(i);
                String Value = attrs.getValue(i);
                if (Name.equals("required")) {
                    this.currentParameter.required = Value.equals("true");
                } else if (Name.equals("type")) {
                    if (Value.equals("node")) {
                        this.currentParameter.type = Type.NODE;
                    } else if (Value.equals("way")) {
                        this.currentParameter.type = Type.WAY;
                    } else if (Value.equals("relation")) {
                        this.currentParameter.type = Type.RELATION;
                    } else if (Value.equals("point")) {
                        this.currentParameter.type = Type.POINT;
                    } else if (Value.equals("length")) {
                        this.currentParameter.type = Type.LENGTH;
                    } else if (Value.equals("natural")) {
                        this.currentParameter.type = Type.NATURAL;
                    } else if (Value.equals("any")) {
                        this.currentParameter.type = Type.ANY;
                    } else if (Value.equals("string")) {
                        this.currentParameter.type = Type.STRING;
                    } else if (Value.equals("relay")) {
                        this.currentParameter.type = Type.RELAY;
                    } else if (Value.equals("username")) {
                        this.currentParameter.type = Type.USERNAME;
                    } else if (Value.equals("imageryurl")) {
                        this.currentParameter.type = Type.IMAGERYURL;
                    } else if (Value.equals("imageryoffset")) {
                        this.currentParameter.type = Type.IMAGERYOFFSET;
                    }
                } else if (Name.equals("maxinstances")) {
                    this.currentParameter.maxInstances = Integer.parseInt(Value);
                } else if (Name.equals("maxvalue")) {
                    this.currentParameter.maxVal = Float.parseFloat(Value);
                } else if (Name.equals("minvalue")) {
                    this.currentParameter.minVal = Float.parseFloat(Value);
                }
                ++i;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String text = new String(ch, start, length).trim();
        if (this.currentParameter != null) {
            if (this.currentTag.equals("name")) {
                this.currentParameter.name = text;
            } else if (this.currentTag.equals("description")) {
                this.currentParameter.description = text;
            } else if (this.currentTag.equals("value")) {
                if (this.currentParameter.type == Type.RELAY) {
                    if (!(this.currentParameter.getRawValue() instanceof Relay)) {
                        this.currentParameter.setValue(new Relay());
                    }
                    ((Relay)this.currentParameter.getRawValue()).addValue(text);
                } else {
                    this.currentParameter.setValue(text);
                }
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) {
        if (rawName.equals("command")) {
            this.loadingCommands.add(this.currentCommand);
            this.currentCommand = null;
        } else if (rawName.equals("parameter")) {
            if (this.currentParameter.required) {
                this.currentCommand.parameters.add(this.currentParameter);
            } else {
                this.currentCommand.optParameters.add(this.currentParameter);
            }
            this.currentParameter = null;
        } else {
            this.currentTag = "";
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        Logging.warn((String)("Warning in command xml file " + this.currentFile + ": " + ex.getMessage()));
    }

    @Override
    public void error(SAXParseException ex) {
        Logging.error((String)("Error in command xml file " + this.currentFile + ": " + ex.getMessage()));
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        Logging.error((String)("Error in command xml file " + this.currentFile + ": " + ex.getMessage()));
        throw ex;
    }
}

