/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.utilsplugin2.command.ChangeRelationMemberCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class UnGlueRelationAction
extends JosmAction {
    public UnGlueRelationAction() {
        super(I18n.tr((String)"UnGlue Relation", (Object[])new Object[0]), "ungluerelations", I18n.tr((String)"Duplicate nodes, ways and relations that are used by multiple relations.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:ungluerelation", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"UnGlue Relations", (Object[])new Object[0])}), (int)71, (int)5007), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/UnGlueRelation"));
    }

    public void actionPerformed(ActionEvent e) {
        LinkedList<Object> cmds = new LinkedList<Object>();
        LinkedList<Node> newPrimitives = new LinkedList<Node>();
        DataSet ds = this.getLayerManager().getEditDataSet();
        Collection selection = ds.getSelected();
        for (OsmPrimitive p : selection) {
            boolean first = true;
            for (Relation relation : Utils.filteredCollection((Collection)p.getReferrers(), Relation.class)) {
                if (relation.isDeleted()) continue;
                if (!first) {
                    Node newp;
                    switch (p.getType()) {
                        case NODE: {
                            newp = new Node((Node)p, true);
                            break;
                        }
                        case WAY: {
                            newp = new Way((Way)p, true);
                            break;
                        }
                        case RELATION: {
                            newp = new Relation((Relation)p, true);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    newPrimitives.add(newp);
                    cmds.add(new AddCommand(ds, (OsmPrimitive)newp));
                    cmds.add((Object)new ChangeRelationMemberCommand(ds, relation, p, (OsmPrimitive)newp));
                    continue;
                }
                first = false;
            }
        }
        if (!newPrimitives.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(I18n.tr((String)"Unglued Relations", (Object[])new Object[0]), cmds));
            newPrimitives.addAll(selection);
            ds.setSelected(newPrimitives);
            MainApplication.getMap().mapView.repaint();
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

