/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DijkstraSP;
import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.EdgeWeightedDigraph;

public class AssignmentProblem {
    private static final int UNMATCHED = -1;
    private int N;
    private double[][] weight;
    private double[] px;
    private double[] py;
    private int[] xy;
    private int[] yx;

    public AssignmentProblem(double[][] weight) {
        this.N = weight.length;
        this.weight = new double[this.N][this.N];
        int i = 0;
        while (i < this.N) {
            int j = 0;
            while (j < this.N) {
                this.weight[i][j] = weight[i][j];
                ++j;
            }
            ++i;
        }
        this.px = new double[this.N];
        this.py = new double[this.N];
        this.xy = new int[this.N];
        this.yx = new int[this.N];
        i = 0;
        while (i < this.N) {
            this.xy[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            this.yx[j] = -1;
            ++j;
        }
        int k = 0;
        while (k < this.N) {
            assert (this.isDualFeasible());
            assert (this.isComplementarySlack());
            this.augment();
            ++k;
        }
        assert (this.check());
    }

    private void augment() {
        EdgeWeightedDigraph G = new EdgeWeightedDigraph(2 * this.N + 2);
        int s = 2 * this.N;
        int t = 2 * this.N + 1;
        int i = 0;
        while (i < this.N) {
            if (this.xy[i] == -1) {
                G.addEdge(new DirectedEdge(s, i, 0.0));
            }
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            if (this.yx[j] == -1) {
                G.addEdge(new DirectedEdge(this.N + j, t, this.py[j]));
            }
            ++j;
        }
        i = 0;
        while (i < this.N) {
            int j2 = 0;
            while (j2 < this.N) {
                if (this.xy[i] == j2) {
                    G.addEdge(new DirectedEdge(this.N + j2, i, 0.0));
                } else {
                    G.addEdge(new DirectedEdge(i, this.N + j2, this.reduced(i, j2)));
                }
                ++j2;
            }
            ++i;
        }
        DijkstraSP spt = new DijkstraSP(G, s);
        for (DirectedEdge e : spt.pathTo(t)) {
            int i2 = e.from();
            int j3 = e.to() - this.N;
            if (i2 >= this.N) continue;
            this.xy[i2] = j3;
            this.yx[j3] = i2;
        }
        int i3 = 0;
        while (i3 < this.N) {
            int n = i3;
            this.px[n] = this.px[n] + spt.distTo(i3);
            ++i3;
        }
        int j4 = 0;
        while (j4 < this.N) {
            int n = j4;
            this.py[n] = this.py[n] + spt.distTo(this.N + j4);
            ++j4;
        }
    }

    private double reduced(int i, int j) {
        return this.weight[i][j] + this.px[i] - this.py[j];
    }

    public double weight() {
        double total = 0.0;
        int i = 0;
        while (i < this.N) {
            if (this.xy[i] != -1) {
                total += this.weight[i][this.xy[i]];
            }
            ++i;
        }
        return total;
    }

    public int sol(int i) {
        return this.xy[i];
    }

    private boolean isDualFeasible() {
        int i = 0;
        while (i < this.N) {
            int j = 0;
            while (j < this.N) {
                if (this.reduced(i, j) < 0.0) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean isComplementarySlack() {
        int i = 0;
        while (i < this.N) {
            if (this.xy[i] != -1 && this.reduced(i, this.xy[i]) != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isPerfectMatching() {
        boolean[] perm = new boolean[this.N];
        int i = 0;
        while (i < this.N) {
            if (perm[this.xy[i]]) {
                return false;
            }
            perm[this.xy[i]] = true;
            ++i;
        }
        int j = 0;
        while (j < this.N) {
            if (this.xy[this.yx[j]] != j) {
                return false;
            }
            ++j;
        }
        i = 0;
        while (i < this.N) {
            if (this.yx[this.xy[i]] != i) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean check() {
        return this.isPerfectMatching() && this.isDualFeasible() && this.isComplementarySlack();
    }
}

