/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.TransText;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractImporterDialog<T extends JosmAction> {
    private static final String[] stoptypes = new String[]{I18n.marktr((String)"bus"), I18n.marktr((String)"tram"), I18n.marktr((String)"light_rail"), I18n.marktr((String)"subway"), I18n.marktr((String)"rail")};
    private final JDialog jDialog;
    protected final JTabbedPane tabbedPane;
    protected final JComboBox<TransText> cbStoptype;
    protected final JTextField tfGPSTimeStart;
    protected final JTextField tfStopwatchStart;
    protected final JTextField tfTimeWindow;
    protected final JTextField tfThreshold;

    public AbstractImporterDialog(T controller, String dialogTitle, String actionPrefix) {
        Frame frame = JOptionPane.getFrameForComponent((Component)MainApplication.getMainFrame());
        this.jDialog = new JDialog(frame, dialogTitle, false);
        this.tabbedPane = new JTabbedPane();
        this.jDialog.add(this.tabbedPane);
        this.cbStoptype = new JComboBox();
        this.cbStoptype.setEditable(false);
        String[] stringArray = stoptypes;
        int n = stoptypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            this.cbStoptype.addItem(new TransText(type));
            ++n2;
        }
        this.cbStoptype.setActionCommand(String.valueOf(actionPrefix) + ".settingsStoptype");
        this.cbStoptype.addActionListener((ActionListener)controller);
        this.tfGPSTimeStart = new JTextField("00:00:00", 15);
        this.tfGPSTimeStart.setActionCommand(String.valueOf(actionPrefix) + ".settingsGPSTimeStart");
        this.tfGPSTimeStart.addActionListener((ActionListener)controller);
        this.tfStopwatchStart = new JTextField("00:00:00", 15);
        this.tfStopwatchStart.setActionCommand(String.valueOf(actionPrefix) + ".settingsStopwatchStart");
        this.tfStopwatchStart.addActionListener((ActionListener)controller);
        this.tfTimeWindow = new JTextField("15", 4);
        this.tfTimeWindow.setActionCommand(String.valueOf(actionPrefix) + ".settingsTimeWindow");
        this.tfTimeWindow.addActionListener((ActionListener)controller);
        this.tfThreshold = new JTextField("20", 4);
        this.tfThreshold.setActionCommand(String.valueOf(actionPrefix) + ".settingsThreshold");
        this.tfThreshold.addActionListener((ActionListener)controller);
        this.initDialog(controller);
        this.jDialog.pack();
        this.jDialog.setLocationRelativeTo(frame);
    }

    protected abstract void initDialog(T var1);

    public void setTrackValid(boolean valid) {
        this.tabbedPane.setEnabledAt(2, valid);
    }

    public void setVisible(boolean visible) {
        this.jDialog.setVisible(visible);
    }

    public void setSettings(String gpsSyncTime, String stopwatchStart, double timeWindow, double threshold) {
        this.tfGPSTimeStart.setText(gpsSyncTime);
        this.tfStopwatchStart.setText(stopwatchStart);
        this.tfTimeWindow.setText(Double.toString(timeWindow));
        this.tfThreshold.setText(Double.toString(threshold));
    }

    public String getStoptype() {
        return ((TransText)this.cbStoptype.getSelectedItem()).text;
    }

    public boolean gpsTimeStartValid() {
        if (AbstractImporterDialog.parseTime(this.tfGPSTimeStart.getText()) >= 0.0) {
            return true;
        }
        JOptionPane.showMessageDialog(null, I18n.tr((String)"Can''t parse a time from this string.", (Object[])new Object[0]), I18n.tr((String)"Invalid value", (Object[])new Object[0]), 0);
        return false;
    }

    public String getGpsTimeStart() {
        return this.tfGPSTimeStart.getText();
    }

    public void setGpsTimeStart(String s) {
        this.tfGPSTimeStart.setText(s);
    }

    public boolean stopwatchStartValid() {
        if (AbstractImporterDialog.parseTime(this.tfStopwatchStart.getText()) >= 0.0) {
            return true;
        }
        JOptionPane.showMessageDialog(null, I18n.tr((String)"Can''t parse a time from this string.", (Object[])new Object[0]), I18n.tr((String)"Invalid value", (Object[])new Object[0]), 0);
        return false;
    }

    public String getStopwatchStart() {
        return this.tfStopwatchStart.getText();
    }

    public void setStopwatchStart(String s) {
        this.tfStopwatchStart.setText(s);
    }

    public double getTimeWindow() {
        return Double.parseDouble(this.tfTimeWindow.getText());
    }

    public double getThreshold() {
        return Double.parseDouble(this.tfThreshold.getText());
    }

    public static double parseTime(String s) {
        if (s.charAt(2) != ':' || s.charAt(5) != ':' || s.length() < 8) {
            return -1.0;
        }
        int hour = Integer.parseInt(s.substring(0, 2));
        int minute = Integer.parseInt(s.substring(3, 5));
        double second = Double.parseDouble(s.substring(6, s.length()));
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0.0 || second >= 60.0) {
            return -1.0;
        }
        return second + (double)(minute * 60) + (double)(hour * 60 * 60);
    }
}

