/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.public_transport.commands;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.public_transport.actions.StopImporterAction;
import org.openstreetmap.josm.plugins.public_transport.dialogs.StopImporterDialog;
import org.openstreetmap.josm.plugins.public_transport.refs.TrackReference;
import org.openstreetmap.josm.tools.I18n;

public class TrackStoplistRelocateCommand
extends Command {
    private StopImporterAction controller = null;
    private TrackReference currentTrack = null;
    private String oldGpsSyncTime = null;
    private String oldStopwatchStart = null;
    private String gpsSyncTime = null;
    private String stopwatchStart = null;

    public TrackStoplistRelocateCommand(StopImporterAction controller) {
        super(MainApplication.getLayerManager().getEditDataSet());
        this.controller = controller;
        this.currentTrack = controller.getCurrentTrack();
        this.gpsSyncTime = controller.getDialog().getGpsTimeStart();
        this.stopwatchStart = controller.getDialog().getStopwatchStart();
        this.oldGpsSyncTime = this.currentTrack.gpsSyncTime;
        this.oldStopwatchStart = this.currentTrack.stopwatchStart;
    }

    public boolean executeCommand() {
        this.currentTrack.gpsSyncTime = this.gpsSyncTime;
        this.currentTrack.stopwatchStart = this.stopwatchStart;
        int i = 0;
        while (i < this.currentTrack.stoplistTM.getNodes().size()) {
            Node node = this.currentTrack.stoplistTM.nodeAt(i);
            if (node != null) {
                double time = StopImporterDialog.parseTime((String)this.currentTrack.stoplistTM.getValueAt(i, 0));
                node.setCoor(this.currentTrack.computeCoor(time));
            }
            ++i;
        }
        if (this.currentTrack == this.controller.getCurrentTrack()) {
            this.controller.inEvent = true;
            this.controller.getDialog().setGpsTimeStart(this.gpsSyncTime);
            this.controller.getDialog().setStopwatchStart(this.stopwatchStart);
            this.controller.inEvent = false;
        }
        return true;
    }

    public void undoCommand() {
        this.currentTrack.gpsSyncTime = this.oldGpsSyncTime;
        this.currentTrack.stopwatchStart = this.oldStopwatchStart;
        int i = 0;
        while (i < this.currentTrack.stoplistTM.getNodes().size()) {
            Node node = this.currentTrack.stoplistTM.nodeAt(i);
            if (node != null) {
                double time = StopImporterDialog.parseTime((String)this.currentTrack.stoplistTM.getValueAt(i, 0));
                node.setCoor(this.currentTrack.computeCoor(time));
            }
            ++i;
        }
        if (this.currentTrack == this.controller.getCurrentTrack()) {
            this.controller.inEvent = true;
            this.controller.getDialog().setGpsTimeStart(this.oldGpsSyncTime);
            this.controller.getDialog().setStopwatchStart(this.oldStopwatchStart);
            this.controller.inEvent = false;
        }
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Public Transport: Relocate nodes in track stoplist", (Object[])new Object[0]);
    }
}

