/*
 * Decompiled with CFR 0.152.
 */
package net.boplicity.xmleditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import net.boplicity.xmleditor.XmlEditorKit;

public class XmlTextPane
extends JTextPane {
    private static final Logger LOGGER = Logger.getLogger(XmlTextPane.class.getName());
    private static final Character NEW_LINE = Character.valueOf('\n');

    public XmlTextPane() {
        this.setEditorKitForContentType("text/xml", new XmlEditorKit());
        this.setContentType("text/xml");
        this.addKeyListener(new IndentKeyListener());
    }

    private class IndentKeyListener
    implements KeyListener {
        private boolean enterFlag;

        private IndentKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent event) {
            this.enterFlag = false;
            if (event.getKeyCode() == 10 && event.getModifiers() == 0 && XmlTextPane.this.getSelectionStart() == XmlTextPane.this.getSelectionEnd()) {
                this.enterFlag = true;
                event.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            if (event.getKeyCode() == 10 && event.getModifiers() == 0 && this.enterFlag) {
                event.consume();
                String text = XmlTextPane.this.getText();
                int caretPosition = XmlTextPane.this.getCaretPosition();
                try {
                    if (text.charAt(caretPosition) == NEW_LINE.charValue()) {
                        --caretPosition;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    LOGGER.log(Level.FINE, e.toString());
                }
                try {
                    int start;
                    if (text.charAt(start) != NEW_LINE.charValue()) {
                        int end;
                        for (end = start = text.lastIndexOf(NEW_LINE.charValue(), caretPosition) + 1; end < text.length() && Character.isWhitespace(text.charAt(end)) && text.charAt(end) != NEW_LINE.charValue(); ++end) {
                        }
                        if (end > start) {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), NEW_LINE + text.substring(start, end), null);
                        } else {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), NEW_LINE.toString(), null);
                        }
                    } else {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), NEW_LINE.toString(), null);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    try {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), NEW_LINE.toString(), null);
                    }
                    catch (BadLocationException e1) {
                        LOGGER.log(Level.WARNING, e1.toString());
                    }
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.WARNING, e.toString());
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

