/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.graphview.plugin.preferences;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyType;
import org.openstreetmap.josm.plugins.graphview.core.property.VehiclePropertyTypes;
import org.openstreetmap.josm.plugins.graphview.core.util.ValueStringParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public final class VehiclePropertyStringParser {
    public static final String ERROR_WEIGHT = I18n.tr((String)"Weights must be given as positive decimal numbers with unit \"t\" or without unit.", (Object[])new Object[0]);
    public static final String ERROR_LENGTH = I18n.tr((String)"Lengths must be given as positive decimal numbers with unit \"m\", \"km\", \"mi\" or without unit.\nAlternatively, the format FEET'' INCHES\" can be used.", (Object[])new Object[0]);
    public static final String ERROR_SPEED = I18n.tr((String)"Speeds should be given as numbers without unit or as numbers followed by \"mph\".", (Object[])new Object[0]);
    public static final String ERROR_INCLINE = I18n.tr((String)"Inclines must be given as positive decimal numbers with followed by \"%\".", (Object[])new Object[0]);
    public static final String ERROR_TRACKTYPE = I18n.tr((String)"Tracktype grades must be given as integers between 0 and 5.", (Object[])new Object[0]);
    public static final String ERROR_SURFACE = I18n.tr((String)"Surface values must not contain any of the following characters: '','', '' '{' '',  '' '}' '', ''='', ''|''", (Object[])new Object[0]);
    private static final List<Character> FORBIDDEN_SURFACE_CHARS = Arrays.asList(Character.valueOf(','), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('='), Character.valueOf('|'));

    private VehiclePropertyStringParser() {
    }

    public static <V> V parsePropertyValue(VehiclePropertyType<V> propertyType, String propertyValueString) throws PropertyValueSyntaxException {
        assert (propertyType != null && propertyValueString != null);
        if (propertyType == VehiclePropertyTypes.AXLELOAD || propertyType == VehiclePropertyTypes.WEIGHT) {
            Float value = ValueStringParser.parseWeight(propertyValueString);
            if (value != null && propertyType.isValidValue(value)) {
                Float result = value;
                return (V)result;
            }
            throw new PropertyValueSyntaxException(ERROR_WEIGHT);
        }
        if (propertyType == VehiclePropertyTypes.HEIGHT || propertyType == VehiclePropertyTypes.LENGTH || propertyType == VehiclePropertyTypes.WIDTH) {
            Float value = ValueStringParser.parseMeasure(propertyValueString);
            if (value != null && propertyType.isValidValue(value)) {
                Float result = value;
                return (V)result;
            }
            throw new PropertyValueSyntaxException(ERROR_LENGTH);
        }
        if (propertyType == VehiclePropertyTypes.SPEED) {
            Float value = ValueStringParser.parseSpeed(propertyValueString);
            if (value != null && propertyType.isValidValue(value)) {
                Float result = value;
                return (V)result;
            }
            throw new PropertyValueSyntaxException(ERROR_SPEED);
        }
        if (propertyType == VehiclePropertyTypes.MAX_INCLINE_DOWN || propertyType == VehiclePropertyTypes.MAX_INCLINE_UP) {
            Float value = ValueStringParser.parseIncline(propertyValueString);
            if (value != null && propertyType.isValidValue(value)) {
                Float result = value;
                return (V)result;
            }
            throw new PropertyValueSyntaxException(ERROR_INCLINE);
        }
        if (propertyType == VehiclePropertyTypes.MAX_TRACKTYPE) {
            try {
                int value = Integer.parseInt(propertyValueString);
                if (value >= 0 && value <= 5) {
                    Integer result = value;
                    return (V)result;
                }
            }
            catch (NumberFormatException e) {
                Logging.trace((Throwable)e);
            }
            throw new PropertyValueSyntaxException(ERROR_TRACKTYPE);
        }
        if (propertyType == VehiclePropertyTypes.SURFACE_BLACKLIST) {
            String[] surfaces = propertyValueString.split(";\\s*");
            ArrayList<String> surfaceBlacklist = new ArrayList<String>(surfaces.length);
            String[] stringArray = surfaces;
            int n = surfaces.length;
            int n2 = 0;
            while (n2 < n) {
                String surface = stringArray[n2];
                char[] cArray = surface.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char nameChar = cArray[n4];
                    if (FORBIDDEN_SURFACE_CHARS.contains(Character.valueOf(nameChar))) {
                        throw new PropertyValueSyntaxException(ERROR_SURFACE);
                    }
                    ++n4;
                }
                surfaceBlacklist.add(surface);
                ++n2;
            }
            ArrayList<String> result = surfaceBlacklist;
            return (V)result;
        }
        throw new InvalidParameterException("Unknown property type: " + propertyType);
    }

    public static class PropertyValueSyntaxException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PropertyValueSyntaxException(String message) {
            super(message);
        }
    }
}

