/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class ReplaceMembershipAction
extends JosmAction {
    public ReplaceMembershipAction() {
        super(I18n.tr((String)"Replace Membership", (Object[])new Object[0]), null, I18n.tr((String)"In relations where the selected object is member of, replace it with a new one", (Object[])new Object[0]), null, false, ReplaceMembershipAction.class.getName(), true);
    }

    public void actionPerformed(ActionEvent e) {
        int affectedRelations;
        OsmPrimitive secondObject;
        Iterator selection = this.getLayerManager().getEditDataSet().getSelected().iterator();
        OsmPrimitive firstObject = (OsmPrimitive)selection.next();
        ReplaceGeometryCommand command = ReplaceMembershipAction.getReplaceGeometryCommand(firstObject, secondObject = (OsmPrimitive)selection.next());
        int n = affectedRelations = command != null ? command.getChildren().size() : 0;
        if (affectedRelations > 0) {
            UndoRedoHandler.getInstance().add((Command)command);
            new Notification(I18n.trn((String)"Replaced ''{0}'' by ''{1}'' in {2} relation", (String)"Replaced ''{0}'' by ''{1}'' in {2} relations", (long)affectedRelations, (Object[])new Object[]{firstObject.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), secondObject.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), affectedRelations})).setIcon(1).show();
        } else {
            new Notification(I18n.tr((String)"The first selected object ''{0}'' is not part of any relation", (Object[])new Object[]{firstObject.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())})).setIcon(2).show();
        }
    }

    static ReplaceGeometryCommand getReplaceGeometryCommand(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        MultiMap byRelation = new MultiMap();
        for (RelationToChildReference i : RelationToChildReference.getRelationToChildReferences((OsmPrimitive)firstObject)) {
            byRelation.put((Object)i.getParent(), (Object)i);
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Map.Entry i : byRelation.entrySet()) {
            Relation oldRelation = (Relation)i.getKey();
            Relation newRelation = new Relation(oldRelation);
            for (RelationToChildReference reference : (Set)i.getValue()) {
                newRelation.setMember(reference.getPosition(), new RelationMember(reference.getRole(), secondObject));
            }
            commands.add((Command)new ChangeCommand((OsmPrimitive)oldRelation, (OsmPrimitive)newRelation));
        }
        return commands.isEmpty() ? null : new ReplaceGeometryCommand(I18n.tr((String)"Replace Membership", (Object[])new Object[0]), commands);
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() == 2);
    }
}

