/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.EdgeWeightedDigraph;
import edu.princeton.cs.algs4.IndexMinPQ;
import edu.princeton.cs.algs4.Stack;

public class DijkstraSP {
    private double[] distTo;
    private DirectedEdge[] edgeTo;
    private IndexMinPQ<Double> pq;

    public DijkstraSP(EdgeWeightedDigraph G, int s) {
        this.distTo = new double[G.V()];
        this.edgeTo = new DirectedEdge[G.V()];
        int v = 0;
        while (v < G.V()) {
            this.distTo[v] = Double.POSITIVE_INFINITY;
            ++v;
        }
        this.distTo[s] = 0.0;
        this.pq = new IndexMinPQ(G.V());
        this.pq.insert(s, this.distTo[s]);
        int count = 0;
        while (!this.pq.isEmpty()) {
            int v2 = this.pq.delMin();
            for (DirectedEdge e : G.adj(v2)) {
                this.relax(e);
            }
            if (++count <= G.V()) continue;
            throw new RuntimeException("Exceeded limit");
        }
        assert (this.check(G, s));
    }

    private void relax(DirectedEdge e) {
        int v = e.from();
        int w = e.to();
        if (this.distTo[w] > this.distTo[v] + e.weight()) {
            this.distTo[w] = this.distTo[v] + e.weight();
            this.edgeTo[w] = e;
            if (this.pq.contains(w)) {
                this.pq.change(w, this.distTo[w]);
            } else {
                this.pq.insert(w, this.distTo[w]);
            }
        }
    }

    public double distTo(int v) {
        return this.distTo[v];
    }

    public boolean hasPathTo(int v) {
        return this.distTo[v] < Double.POSITIVE_INFINITY;
    }

    public Iterable<DirectedEdge> pathTo(int v) {
        if (!this.hasPathTo(v)) {
            return null;
        }
        Stack<DirectedEdge> path = new Stack<DirectedEdge>();
        DirectedEdge e = this.edgeTo[v];
        while (e != null) {
            path.push(e);
            e = this.edgeTo[e.from()];
        }
        return path;
    }

    private boolean check(EdgeWeightedDigraph G, int s) {
        for (DirectedEdge e : G.edges()) {
            if (!(e.weight() < 0.0)) continue;
            System.err.println("negative edge weight detected");
            return false;
        }
        if (this.distTo[s] != 0.0 || this.edgeTo[s] != null) {
            System.err.println("distTo[s] and edgeTo[s] inconsistent");
            return false;
        }
        int v = 0;
        while (v < G.V()) {
            if (v != s && this.edgeTo[v] == null && this.distTo[v] != Double.POSITIVE_INFINITY) {
                System.err.println("distTo[] and edgeTo[] inconsistent");
                return false;
            }
            ++v;
        }
        v = 0;
        while (v < G.V()) {
            for (DirectedEdge e : G.adj(v)) {
                int w = e.to();
                if (!(this.distTo[v] + e.weight() < this.distTo[w])) continue;
                System.err.println("edge " + e + " not relaxed");
                return false;
            }
            ++v;
        }
        int w = 0;
        while (w < G.V()) {
            if (this.edgeTo[w] != null) {
                DirectedEdge e;
                e = this.edgeTo[w];
                int v2 = e.from();
                if (w != e.to()) {
                    return false;
                }
                if (this.distTo[v2] + e.weight() != this.distTo[w]) {
                    System.err.println("edge " + e + " on shortest path not tight");
                    return false;
                }
            }
            ++w;
        }
        return true;
    }
}

