/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public final class ColorMap {
    private List<ColorMapEntry> colorList;
    private String name;
    private static HashMap<String, ColorMap> colorMaps = new HashMap();

    private ColorMap() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor(int elevation) {
        if (this.colorList == null || this.colorList.size() == 0) {
            return Color.white;
        }
        if (elevation < this.colorList.get(0).ele) {
            return this.colorList.get(0).getColor();
        }
        int last = this.colorList.size() - 1;
        if (elevation > this.colorList.get(last).ele) {
            return this.colorList.get(last).getColor();
        }
        int i = 0;
        while (i < last) {
            ColorMapEntry e1 = this.colorList.get(i);
            ColorMapEntry e2 = this.colorList.get(i + 1);
            if (e1.getEle() <= elevation && e2.getEle() >= elevation) {
                double val = (double)(elevation - e1.getEle()) / (double)(e2.getEle() - e1.getEle());
                return ColorMap.interpolate(e1.getColor(), e2.getColor(), val);
            }
            ++i;
        }
        throw new RuntimeException("Inconsistent color map - found no entry for elevation " + elevation);
    }

    public static ColorMap getMap(String name) {
        if (colorMaps.containsKey(name)) {
            return colorMaps.get(name);
        }
        return null;
    }

    public static int size() {
        return colorMaps != null ? colorMaps.size() : 0;
    }

    public static String[] getNames() {
        return colorMaps.keySet().toArray(new String[ColorMap.size()]);
    }

    private static void registerColorMap(ColorMap newMap) {
        CheckParameterUtil.ensureParameterNotNull((Object)newMap);
        colorMaps.put(newMap.getName(), newMap);
    }

    public static void unregisterColorMap(String name) {
        if (colorMaps.containsKey(name)) {
            colorMaps.remove(name);
        }
    }

    public static Color interpolate(Color c1, Color c2, double ratio) {
        double r1 = 1.0 - ratio;
        if (r1 < 0.0) {
            r1 = 0.0;
        }
        if (r1 > 1.0) {
            r1 = 1.0;
        }
        double r2 = 1.0 - r1;
        int r = (int)Math.round(r1 * (double)c1.getRed() + r2 * (double)c2.getRed());
        int g = (int)Math.round(r1 * (double)c1.getGreen() + r2 * (double)c2.getGreen());
        int b = (int)Math.round(r1 * (double)c1.getBlue() + r2 * (double)c2.getBlue());
        return new Color(r, g, b);
    }

    public static ColorMap create(String name, Color[] colors, int[] ele) {
        CheckParameterUtil.ensureParameterNotNull((Object)colors);
        CheckParameterUtil.ensureParameterNotNull((Object)ele);
        if (colors.length != ele.length) {
            throw new IllegalArgumentException("Arrays colors and ele must have same length: " + colors.length + " vs " + ele.length);
        }
        ColorMap map = new ColorMap();
        map.colorList = new ArrayList<ColorMapEntry>();
        map.name = name;
        int i = 0;
        while (i < ele.length) {
            map.colorList.add(new ColorMapEntry(colors[i], ele[i]));
            ++i;
        }
        Collections.sort(map.colorList);
        ColorMap.registerColorMap(map);
        return map;
    }

    static class ColorMapEntry
    implements Comparable<ColorMapEntry> {
        private final int ele;
        private final Color color;

        ColorMapEntry(Color color, int ele) {
            this.color = color;
            this.ele = ele;
        }

        public int getEle() {
            return this.ele;
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public int compareTo(ColorMapEntry o) {
            return this.ele - o.ele;
        }
    }
}

