/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.geojson;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.simple.parser.JSONParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoJsonReader {
    private GeometryFactory gf;

    public GeoJsonReader() {
    }

    public GeoJsonReader(GeometryFactory geometryFactory) {
        this.gf = geometryFactory;
    }

    public Geometry read(String json) throws ParseException {
        Geometry result = this.read(new StringReader(json));
        return result;
    }

    public Geometry read(Reader reader) throws ParseException {
        Geometry result = null;
        JSONParser parser = new JSONParser();
        try {
            Map geometryMap = (Map)parser.parse(reader);
            GeometryFactory geometryFactory = null;
            geometryFactory = this.gf == null ? this.getGeometryFactory(geometryMap) : this.gf;
            result = this.create(geometryMap, geometryFactory);
        }
        catch (org.json.simple.parser.ParseException e) {
            throw new ParseException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
        return result;
    }

    private Geometry create(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Geometry result = null;
        String type = (String)geometryMap.get("type");
        if (type == null) {
            throw new ParseException("Could not parse Geometry from Json string.  No 'type' property found.");
        }
        if ("Point".equals(type)) {
            result = this.createPoint(geometryMap, geometryFactory);
        } else if ("LineString".equals(type)) {
            result = this.createLineString(geometryMap, geometryFactory);
        } else if ("Polygon".equals(type)) {
            result = this.createPolygon(geometryMap, geometryFactory);
        } else if ("MultiPoint".equals(type)) {
            result = this.createMultiPoint(geometryMap, geometryFactory);
        } else if ("MultiLineString".equals(type)) {
            result = this.createMultiLineString(geometryMap, geometryFactory);
        } else if ("MultiPolygon".equals(type)) {
            result = this.createMultiPolygon(geometryMap, geometryFactory);
        } else if ("GeometryCollection".equals(type)) {
            result = this.createGeometryCollection(geometryMap, geometryFactory);
        } else {
            throw new ParseException("Could not parse Geometry from GeoJson string.  Unsupported 'type':" + type);
        }
        return result;
    }

    private Geometry createGeometryCollection(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        GeometryCollection result = null;
        try {
            List geometriesList = (List)geometryMap.get("geometries");
            Geometry[] geometries = new Geometry[geometriesList.size()];
            int i = 0;
            for (Map map : geometriesList) {
                geometries[i] = this.create(map, geometryFactory);
                ++i;
            }
            result = geometryFactory.createGeometryCollection(geometries);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse GeometryCollection from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createMultiPolygon(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiPolygon result = null;
        try {
            List polygonsList = (List)geometryMap.get("coordinates");
            Polygon[] polygons = new Polygon[polygonsList.size()];
            int p = 0;
            for (List ringsList : polygonsList) {
                ArrayList<CoordinateSequence> rings = new ArrayList<CoordinateSequence>();
                for (List coordinates : ringsList) {
                    rings.add(this.createCoordinateSequence(coordinates));
                }
                if (rings.isEmpty()) continue;
                LinearRing outer = geometryFactory.createLinearRing((CoordinateSequence)rings.get(0));
                LinearRing[] inner = null;
                if (rings.size() > 1) {
                    inner = new LinearRing[rings.size() - 1];
                    int i = 1;
                    while (i < rings.size()) {
                        inner[i - 1] = geometryFactory.createLinearRing((CoordinateSequence)rings.get(i));
                        ++i;
                    }
                }
                polygons[p] = geometryFactory.createPolygon(outer, inner);
                ++p;
            }
            result = geometryFactory.createMultiPolygon(polygons);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiPolygon from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createMultiLineString(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiLineString result = null;
        try {
            List linesList = (List)geometryMap.get("coordinates");
            LineString[] lineStrings = new LineString[linesList.size()];
            int i = 0;
            for (List coordinates : linesList) {
                lineStrings[i] = geometryFactory.createLineString(this.createCoordinateSequence(coordinates));
                ++i;
            }
            result = geometryFactory.createMultiLineString(lineStrings);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiLineString from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createMultiPoint(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        MultiPoint result = null;
        try {
            List coordinatesList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinates = this.createCoordinateSequence(coordinatesList);
            result = geometryFactory.createMultiPoint(coordinates);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse MultiPoint from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createPolygon(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Polygon result = null;
        try {
            List ringsList = (List)geometryMap.get("coordinates");
            ArrayList<CoordinateSequence> rings = new ArrayList<CoordinateSequence>();
            for (List coordinates : ringsList) {
                rings.add(this.createCoordinateSequence(coordinates));
            }
            if (rings.isEmpty()) {
                throw new IllegalArgumentException("Polygon specified with no rings.");
            }
            LinearRing outer = geometryFactory.createLinearRing((CoordinateSequence)rings.get(0));
            LinearRing[] inner = null;
            if (rings.size() > 1) {
                inner = new LinearRing[rings.size() - 1];
                int i = 1;
                while (i < rings.size()) {
                    inner[i - 1] = geometryFactory.createLinearRing((CoordinateSequence)rings.get(i));
                    ++i;
                }
            }
            result = geometryFactory.createPolygon(outer, inner);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse Polygon from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createLineString(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        LineString result = null;
        try {
            List coordinatesList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinates = this.createCoordinateSequence(coordinatesList);
            result = geometryFactory.createLineString(coordinates);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse LineString from GeoJson string.", e);
        }
        return result;
    }

    private Geometry createPoint(Map<String, Object> geometryMap, GeometryFactory geometryFactory) throws ParseException {
        Point result = null;
        try {
            List coordinateList = (List)geometryMap.get("coordinates");
            CoordinateSequence coordinate = this.createCoordinate(coordinateList);
            result = geometryFactory.createPoint(coordinate);
        }
        catch (RuntimeException e) {
            throw new ParseException("Could not parse Point from GeoJson string.", e);
        }
        return result;
    }

    private GeometryFactory getGeometryFactory(Map<String, Object> geometryMap) throws ParseException {
        GeometryFactory result = null;
        Map crsMap = (Map)geometryMap.get("crs");
        Integer srid = null;
        if (crsMap != null) {
            try {
                Map propertiesMap = (Map)crsMap.get("properties");
                String name = (String)propertiesMap.get("name");
                String[] split = name.split(":");
                String epsg = split[1];
                srid = Integer.valueOf(epsg);
            }
            catch (RuntimeException e) {
                throw new ParseException("Could not parse SRID from Geojson 'crs' object.", e);
            }
        }
        if (srid == null) {
            srid = 4326;
        }
        result = new GeometryFactory(new PrecisionModel(), srid);
        return result;
    }

    private CoordinateSequence createCoordinateSequence(List<List<Number>> coordinates) {
        CoordinateArraySequence result = null;
        result = new CoordinateArraySequence(coordinates.size());
        int i = 0;
        while (i < coordinates.size()) {
            List<Number> ordinates = coordinates.get(i);
            if (ordinates.size() > 0) {
                result.setOrdinate(i, 0, ordinates.get(0).doubleValue());
            }
            if (ordinates.size() > 1) {
                result.setOrdinate(i, 1, ordinates.get(1).doubleValue());
            }
            if (ordinates.size() > 2) {
                result.setOrdinate(i, 2, ordinates.get(2).doubleValue());
            }
            ++i;
        }
        return result;
    }

    private CoordinateSequence createCoordinate(List<Number> ordinates) {
        CoordinateArraySequence result = new CoordinateArraySequence(1);
        if (ordinates.size() > 0) {
            result.setOrdinate(0, 0, ordinates.get(0).doubleValue());
        }
        if (ordinates.size() > 1) {
            result.setOrdinate(0, 1, ordinates.get(1).doubleValue());
        }
        if (ordinates.size() > 2) {
            result.setOrdinate(0, 2, ordinates.get(2).doubleValue());
        }
        return result;
    }
}

