/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid.io;

import java.io.IOException;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.RenamingGranuleSource;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.opengis.filter.Filter;

public class RenamingGranuleStore
extends RenamingGranuleSource
implements GranuleStore {
    private final GranuleStore store;

    public RenamingGranuleStore(String name, GranuleStore delegate) throws IOException {
        super(name, delegate);
        this.store = delegate;
    }

    @Override
    public void addGranules(SimpleFeatureCollection granules) {
        try {
            ReTypingFeatureCollection backMapped = new ReTypingFeatureCollection(granules, this.delegate.getSchema());
            this.store.addGranules(backMapped);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int removeGranules(Filter filter) {
        return this.store.removeGranules(filter);
    }

    @Override
    public void updateGranules(String[] attributeNames, Object[] attributeValues, Filter filter) {
        this.store.updateGranules(attributeNames, attributeValues, filter);
    }

    @Override
    public Transaction getTransaction() {
        return this.store.getTransaction();
    }

    @Override
    public void setTransaction(Transaction transaction) {
        this.store.setTransaction(transaction);
    }
}

