/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.actions;

import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import com.innovant.josm.plugin.routing.gui.RoutingDialog;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MoveRouteNodeAction
extends MapMode {
    private static final int DRAG_SQR_RADIUS = 100;
    static Logger logger = Logger.getLogger(RoutingLayer.class);
    private int index;

    public MoveRouteNodeAction() {
        super(I18n.tr((String)"Routing", (Object[])new Object[0]), "move", I18n.tr((String)"Click and drag to move destination", (Object[])new Object[0]), ImageProvider.getCursor((String)"normal", (String)"move"));
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
            this.requestFocusInMapView();
            RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
            RoutingModel routingModel = layer.getRoutingModel();
            List<Node> nl = routingModel.getSelectedNodes();
            this.index = -1;
            double dmax = 100.0;
            int i = 0;
            while (i < nl.size()) {
                Node node = nl.get(i);
                double d = MainApplication.getMap().mapView.getPoint(node).distanceSq(e.getPoint());
                if (d < dmax) {
                    dmax = d;
                    this.index = i;
                }
                ++i;
            }
            if (this.index >= 0) {
                logger.debug((Object)("Moved from node " + nl.get(this.index)));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && this.index >= 0) {
            this.searchAndReplaceNode(e.getPoint());
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private void searchAndReplaceNode(Point point) {
        if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
            RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
            RoutingModel routingModel = layer.getRoutingModel();
            RoutingDialog routingDialog = RoutingPlugin.getInstance().getRoutingDialog();
            Node node = null;
            node = layer.getNearestHighwayNode(point);
            if (node == null) {
                logger.debug((Object)"Didn't found a close node to move to.");
                return;
            }
            logger.debug((Object)("Moved to node " + node));
            routingModel.removeNode(this.index);
            routingDialog.removeNode(this.index);
            routingModel.insertNode(this.index, node);
            routingDialog.insertNode(this.index, node);
            MainApplication.getMap().repaint();
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof RoutingLayer;
    }
}

