/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import crosby.binary.Osmformat;
import crosby.binary.StringTable;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.FileBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BinarySerializer {
    protected final int MIN_DENSE = 10;
    protected int batch_limit = 4000;
    protected int granularity = 100;
    protected int date_granularity = 1000;
    protected boolean omit_metadata = false;
    protected int batch_size = 0;
    protected int total_entities = 0;
    private StringTable stringtable = new StringTable();
    protected List<PrimGroupWriterInterface> groups = new ArrayList<PrimGroupWriterInterface>();
    protected BlockOutputStream output;
    long debug_bytes = 0L;

    public void configGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void configOmit(boolean omit_metadata) {
        this.omit_metadata = omit_metadata;
    }

    public void configBatchLimit(int batch_limit) {
        this.batch_limit = batch_limit;
    }

    public BinarySerializer(BlockOutputStream output) {
        this.output = output;
    }

    public StringTable getStringTable() {
        return this.stringtable;
    }

    public void flush() throws IOException {
        this.processBatch();
        this.output.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.output.close();
    }

    public void processBatch() {
        if (this.groups.size() == 0) {
            return;
        }
        Osmformat.PrimitiveBlock.Builder primblock = Osmformat.PrimitiveBlock.newBuilder();
        this.stringtable.clear();
        for (PrimGroupWriterInterface i : this.groups) {
            i.addStringsToStringtable();
        }
        this.stringtable.finish();
        for (PrimGroupWriterInterface i : this.groups) {
            Osmformat.PrimitiveGroup group = i.serialize();
            if (group == null) continue;
            primblock.addPrimitivegroup(group);
        }
        primblock.setStringtable(this.stringtable.serialize());
        primblock.setGranularity(this.granularity);
        primblock.setDateGranularity(this.date_granularity);
        Osmformat.PrimitiveBlock message = (Osmformat.PrimitiveBlock)primblock.build();
        this.debug_bytes += (long)message.getSerializedSize();
        try {
            try {
                this.output.write(FileBlock.newInstance("OSMData", message.toByteString(), null));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new Error(e);
            }
        }
        finally {
            this.batch_size = 0;
            this.groups.clear();
        }
    }

    public long mapRawDegrees(double degrees) {
        return (long)(degrees / 1.0E-9);
    }

    public int mapDegrees(double degrees) {
        return (int)(degrees / 1.0E-7 / (double)(this.granularity / 100));
    }

    protected static interface PrimGroupWriterInterface {
        public void addStringsToStringtable();

        public Osmformat.PrimitiveGroup serialize();
    }
}

